/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ComponentNode
implements TreeNode {
    private ComponentNode mParent;
    private Component mComponent;

    public ComponentNode(ComponentNode componentNode, Component component) {
        this.mParent = componentNode;
        this.mComponent = component;
    }

    public Component getComponent() {
        return this.mComponent;
    }

    public Enumeration children() {
        Vector<TreeNode> vector = new Vector<TreeNode>();
        int n = this.getChildCount();
        int n2 = 0;
        while (n2 < n) {
            vector.add(this.getChildAt(n2));
            ++n2;
        }
        return vector.elements();
    }

    public boolean getAllowsChildren() {
        return this.mComponent == null || this.mComponent instanceof Container;
    }

    public TreeNode getChildAt(int n) {
        Component component;
        if (this.mComponent == null) {
            component = (Window)this.getAllWindows().elementAt(n);
        } else if (this.mComponent instanceof Container) {
            Container container = (Container)this.mComponent;
            int n2 = container.getComponentCount();
            if (n >= n2 && container instanceof Window) {
                Window[] windowArray = ((Window)container).getOwnedWindows();
                component = windowArray[n - n2];
            } else {
                component = container.getComponent(n);
            }
        } else {
            throw new RuntimeException("no child with index " + n);
        }
        return new ComponentNode(this, component);
    }

    public int getChildCount() {
        int n = 0;
        if (this.mComponent == null) {
            n = this.getAllWindows().size();
        } else if (this.mComponent instanceof Container) {
            Container container = (Container)this.mComponent;
            n = container.getComponentCount();
            if (container instanceof Window) {
                n += ((Window)container).getOwnedWindows().length;
            }
        }
        return n;
    }

    public int getIndex(TreeNode treeNode) {
        int n = -1;
        int n2 = this.getChildCount();
        int n3 = 0;
        while (n3 < n2) {
            if (treeNode.equals(this.getChildAt(n3))) {
                n = n3;
                break;
            }
            ++n3;
        }
        return n;
    }

    private Vector getAllWindows() {
        Frame[] frameArray = Frame.getFrames();
        Vector<Frame> vector = new Vector<Frame>(frameArray.length);
        if (frameArray == null || frameArray.length == 0) {
            vector.trimToSize();
            return vector;
        }
        int n = 0;
        while (n < frameArray.length) {
            if (frameArray[n] != null && frameArray[n] instanceof Frame && frameArray[n].isShowing() && !"ComponentBrowser".equals(frameArray[n].getTitle())) {
                vector.addElement(frameArray[n]);
            }
            ++n;
        }
        vector.trimToSize();
        return vector;
    }

    public TreeNode getParent() {
        return this.mParent;
    }

    public boolean isLeaf() {
        return !this.getAllowsChildren() || this.getChildCount() == 0;
    }

    public int hashCode() {
        return this.mComponent == null ? 1 : this.mComponent.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof ComponentNode && this.mComponent == ((ComponentNode)object).mComponent;
    }

    public String toString() {
        if (this.mComponent == null) {
            return "All Frames";
        }
        return this.mComponent.getName() == null ? this.mComponent.getClass().getName() + " : " + this.mComponent.hashCode() : this.mComponent.getName();
    }
}

