/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultTreeModel;
import junit.extensions.jfcunit.tools.ComponentNode;

public class ComponentBrowser
extends JFrame
implements ActionListener,
TreeSelectionListener,
WindowListener {
    protected static final String TITLE = "ComponentBrowser";
    private JButton refreshButton;
    private JTree componentTree;
    private DefaultTableModel propTableModel;
    static /* synthetic */ Class class$java$awt$Component;

    public ComponentBrowser() {
        this.setTitle(TITLE);
        this.equip(this.getContentPane());
        ((Component)this).setSize(400, 300);
        this.pack();
        ((Component)this).setVisible(true);
        this.addWindowListener(this);
    }

    public static void main(String[] stringArray) {
        new ComponentBrowser();
    }

    private void equip(Container container) {
        container.setSize(400, 300);
        container.add((Component)new JSplitPane(1, this.createLeftPanel(), this.createRightPanel()), "Center");
    }

    private JButton createReloadButton() {
        JButton jButton = new JButton("Reload");
        jButton.addActionListener(this);
        return jButton;
    }

    private JPanel createLeftPanel() {
        this.componentTree = new JTree(new ComponentNode(null, null));
        this.componentTree.addTreeSelectionListener(this);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setSize(100, 300);
        jPanel.setPreferredSize(jPanel.getSize());
        jPanel.add((Component)new JScrollPane(this.componentTree), "Center");
        this.refreshButton = this.createReloadButton();
        jPanel.add((Component)this.refreshButton, "South");
        return jPanel;
    }

    private JScrollPane createRightPanel() {
        Vector<String> vector = new Vector<String>(2);
        vector.add("Prop name");
        vector.add("Value");
        this.propTableModel = new DefaultTableModel(vector, 0);
        JTable jTable = new JTable(this.propTableModel);
        jTable.setAutoResizeMode(4);
        JScrollPane jScrollPane = new JScrollPane(jTable);
        jScrollPane.setSize(new Dimension(300, 300));
        jScrollPane.setPreferredSize(jScrollPane.getSize());
        jScrollPane.setColumnHeaderView(jTable.getTableHeader());
        return jScrollPane;
    }

    public boolean isComponentSelected() {
        return (ComponentNode)this.componentTree.getLastSelectedPathComponent() != null;
    }

    private void componentSelected(Component component) {
        this.propTableModel.setNumRows(0);
        if (component == null) {
            return;
        }
        Class<?> clazz = component.getClass();
        Vector vector = new Vector();
        while ((class$java$awt$Component == null ? ComponentBrowser.class$("java.awt.Component") : class$java$awt$Component).isAssignableFrom(clazz)) {
            Method[] methodArray = clazz.getDeclaredMethods();
            int n = 0;
            while (n < methodArray.length) {
                if (this.isAccessibleGetterMethod(methodArray[n])) {
                    this.addProperty(component, methodArray[n], vector);
                }
                ++n;
            }
            clazz = clazz.getSuperclass();
        }
        this.propTableModel.fireTableDataChanged();
    }

    private boolean isAccessibleGetterMethod(Method method) {
        return method.getName().startsWith("get") || method.getName().startsWith("is");
    }

    private String getPropertyName(String string) {
        String string2 = null;
        if (string.startsWith("get")) {
            string2 = string.substring(3);
        } else if (string.startsWith("is")) {
            string2 = string.substring(2);
        }
        return string2.substring(0, 1).toLowerCase() + string2.substring(1);
    }

    private void addProperty(Component component, Method method, Vector vector) {
        String string = method.getName();
        if (vector.contains(string)) {
            return;
        }
        vector.addElement(string);
        try {
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length == 0) {
                Vector<Object> vector2 = new Vector<Object>(2);
                vector2.addElement(this.getPropertyName(method.getName()));
                vector2.addElement(method.invoke((Object)component, (Object[])new Class[0]));
                this.propTableModel.addRow(vector2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refreshButton) {
            ((DefaultTreeModel)this.componentTree.getModel()).reload();
        }
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getSource() == this.componentTree && this.isComponentSelected()) {
            ComponentNode componentNode = (ComponentNode)this.componentTree.getLastSelectedPathComponent();
            this.componentSelected(componentNode.getComponent());
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        System.exit(0);
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

