/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import javax.swing.JViewport;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.MouseEventData;

public class MouseWheelEventData
extends MouseEventData {
    public static final boolean DEFAULT_ISPOPUPTRIGGER = false;
    public static final int DEFAULT_MOUSE_CLICKS = 0;
    private static int mouseWheelEvent;
    private static Class mweClass;
    private static Method getWheelRotationMethod;
    private static Method getScrollAmountMethod;
    private Component comp;
    private int wheelRotation = 0;
    private int scrollAmount = 0;

    public MouseWheelEventData() {
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component) {
        this(jFCTestCase, component, 3, 1);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n) {
        this(jFCTestCase, component, 3, n, 0);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2) {
        this(jFCTestCase, component, n, n2, 0);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3) {
        this(jFCTestCase, component, n, n2, n3, 16);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4) {
        this(jFCTestCase, component, n, n2, n3, n4, false);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, boolean bl) {
        this(jFCTestCase, component, n, n2, n3, AbstractMouseEventData.getDefaultModifiers(bl), bl);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, long l) {
        this(jFCTestCase, component, n, n2, n3, 16, false, l);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4, boolean bl) {
        this(jFCTestCase, component, n, n2, n3, n4, bl, 300L);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, component, n, n2, n3, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4, boolean bl, long l) {
        this(jFCTestCase, component, n, n2, n3, n4, bl, l, 0, null);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4, boolean bl, long l, int n5) {
        this(jFCTestCase, component, n, n2, n3, n4, bl, l, n5, null);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4, boolean bl, long l, Point point) {
        this(jFCTestCase, component, n, n2, n3, n4, bl, l, 12, point);
    }

    public MouseWheelEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, int n3, int n4, boolean bl, long l, int n5, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(component);
        this.setScrollAmount(n);
        this.setWheelRotation(n2);
        this.setNumberOfClicks(n3);
        this.setModifiers(n4);
        this.setPopupTrigger(bl);
        this.setSleepTime(l);
        this.setPosition(n5);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(Component component) {
        this.comp = component;
    }

    public Component getSource() {
        return this.comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setScrollAmount(int n) {
        this.scrollAmount = n;
    }

    public int getScrollAmount() {
        return this.scrollAmount;
    }

    public void setWheelRotation(int n) {
        this.wheelRotation = n;
    }

    public int getWheelRotation() {
        return this.wheelRotation;
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        Container container = null;
        container = this.getSource() instanceof Container ? (Container)this.getSource() : this.getSource().getParent();
        while (container.getParent() != null && !(container instanceof JViewport)) {
            container = container.getParent();
        }
        if (!(container instanceof JViewport)) {
            return false;
        }
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.awtSleep(this.getSleepTime());
        }
        Rectangle rectangle = container.getBounds();
        this.setLocationOnScreen(this.calculatePoint(rectangle));
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        try {
            int n = (Integer)getScrollAmountMethod.invoke((Object)aWTEvent, new Object[0]);
            this.setScrollAmount(n);
            int n2 = (Integer)getWheelRotationMethod.invoke((Object)aWTEvent, new Object[0]);
            this.setWheelRotation(n2 + this.getWheelRotation());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.isValid()) {
            return true;
        }
        Component component = (Component)mouseEvent.getSource();
        this.setSource(component);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = component.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (mouseWheelEvent == 0 || aWTEvent.getID() != mouseWheelEvent) {
            return false;
        }
        if (this.isValid()) {
            int n = ((MouseEvent)aWTEvent).getModifiers();
            if (aWTEvent.getSource() != this.getSource()) {
                return false;
            }
            if (n != this.getModifiers()) {
                return false;
            }
            try {
                int n2 = (Integer)getWheelRotationMethod.invoke((Object)aWTEvent, new Object[0]);
                if (n2 * this.getWheelRotation() < 0) {
                    return false;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" amount:" + this.getScrollAmount());
        stringBuffer.append(" rotation:" + this.getWheelRotation());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof MouseWheelEventData)) {
            return false;
        }
        MouseWheelEventData mouseWheelEventData = (MouseWheelEventData)object;
        return super.equals(object) && mouseWheelEventData.getWheelRotation() == this.getWheelRotation() && mouseWheelEventData.getScrollAmount() == this.getScrollAmount();
    }

    static {
        try {
            mweClass = Class.forName("java.awt.event.MouseWheelEvent");
            mouseWheelEvent = mweClass.getField("MOUSE_WHEEL").getInt(null);
            getWheelRotationMethod = mweClass.getMethod("getWheelRotation", new Class[0]);
            getScrollAmountMethod = mweClass.getMethod("getScrollAmount", new Class[0]);
        }
        catch (Exception exception) {
            mouseWheelEvent = 0;
        }
    }
}

