/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class MouseEventData
extends AbstractMouseEventData {
    public static final boolean DEFAULT_ISPOPUPTRIGGER = false;
    private Component comp;

    public MouseEventData() {
        this.setValid(false);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component) {
        this(jFCTestCase, component, 1);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n) {
        this(jFCTestCase, component, n, 16);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, long l) {
        this(jFCTestCase, component, 1, l);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2) {
        this(jFCTestCase, component, n, n2, false);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, boolean bl) {
        this(jFCTestCase, component, n, AbstractMouseEventData.getDefaultModifiers(bl), bl);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, long l) {
        this(jFCTestCase, component, n, 16, false, l);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, boolean bl) {
        this(jFCTestCase, component, n, n2, bl, 300L);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, boolean bl, long l) {
        this(jFCTestCase, component, n, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, component, n, n2, bl, l, 0, null);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, boolean bl, long l, int n3) {
        this(jFCTestCase, component, n, n2, bl, l, n3, null);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, boolean bl, long l, Point point) {
        this(jFCTestCase, component, n, n2, bl, l, 12, point);
    }

    public MouseEventData(JFCTestCase jFCTestCase, Component component, int n, int n2, boolean bl, long l, int n3, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(component);
        this.setNumberOfClicks(n);
        this.setModifiers(n2);
        this.setPopupTrigger(bl);
        this.setSleepTime(l);
        this.setPosition(n3);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(Component component) {
        this.comp = component;
    }

    public Component getSource() {
        return this.comp;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public boolean prepareComponent() {
        if (!this.isValidForProcessing(this.comp)) {
            return false;
        }
        this.requestFocus(this.comp);
        Rectangle rectangle = this.comp.getBounds();
        rectangle.setLocation(this.comp.getLocationOnScreen());
        this.setLocationOnScreen(this.calculatePoint(rectangle));
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        Component component = (Component)mouseEvent.getSource();
        this.setSource(component);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = component.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        return super.canConsume(aWTEvent);
    }

    public boolean equals(Object object) {
        if (!(object instanceof MouseEventData)) {
            return false;
        }
        MouseEventData mouseEventData = (MouseEventData)object;
        return super.equals(object);
    }
}

