/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class JTabbedPaneMouseEventData
extends AbstractMouseEventData {
    public static final boolean DEFAULT_ISPOPUPTRIGGER = false;
    public static final String DEFAULT_TITLE = "";
    private JTabbedPane tabPane;
    private int tabIndex;
    private String title;

    public JTabbedPaneMouseEventData() {
        this.setValid(false);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, int n2) {
        this(jFCTestCase, jTabbedPane, n, DEFAULT_TITLE, n2);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2) {
        this(jFCTestCase, jTabbedPane, n, string, n2, 300L);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, int n2, long l) {
        this(jFCTestCase, jTabbedPane, n, DEFAULT_TITLE, n2, l);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, long l) {
        this(jFCTestCase, jTabbedPane, n, string, n2, false, l);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, int n2, boolean bl) {
        this(jFCTestCase, jTabbedPane, n, DEFAULT_TITLE, n2, bl);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, boolean bl) {
        this(jFCTestCase, jTabbedPane, n, string, n2, bl, 300L);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, int n2, boolean bl, long l) {
        this(jFCTestCase, jTabbedPane, n, DEFAULT_TITLE, n2, bl, l);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, boolean bl, long l) {
        this(jFCTestCase, jTabbedPane, n, string, n2, AbstractMouseEventData.getDefaultModifiers(bl), bl, l);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, int n3, boolean bl, long l) {
        this(jFCTestCase, jTabbedPane, n, string, n2, n3, bl, l, 0, null);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, int n3, boolean bl, long l, int n4) {
        this(jFCTestCase, jTabbedPane, n, string, n2, n3, bl, l, n4, null);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, int n3, boolean bl, long l, Point point) {
        this(jFCTestCase, jTabbedPane, n, string, n2, n3, bl, l, 12, point);
    }

    public JTabbedPaneMouseEventData(JFCTestCase jFCTestCase, JTabbedPane jTabbedPane, int n, String string, int n2, int n3, boolean bl, long l, int n4, Point point) {
        this.setTestCase(jFCTestCase);
        this.setSource(jTabbedPane);
        this.setNumberOfClicks(n2);
        this.setModifiers(n3);
        this.setPopupTrigger(bl);
        this.setTabIndex(n);
        this.setTitle(string);
        this.setSleepTime(l);
        this.setPosition(n4);
        this.setReferencePoint(point);
        this.setValid(true);
    }

    public void setSource(JTabbedPane jTabbedPane) {
        this.tabPane = jTabbedPane;
    }

    public JTabbedPane getSource() {
        return this.tabPane;
    }

    public Component getComponent() {
        return this.getSource();
    }

    public void setTabIndex(int n) {
        this.tabIndex = n;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean prepareComponent() {
        Cloneable cloneable;
        if (!this.isValidForProcessing(this.getSource())) {
            return false;
        }
        if (this.tabIndex < 0) {
            this.tabIndex = this.tabPane.indexOfTab(this.getTitle());
        }
        if (this.tabPane.getBoundsAt(this.tabIndex) == null) {
            return false;
        }
        this.requestFocus(this.tabPane);
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle = this.tabPane.getBoundsAt(this.tabIndex);
        if (this.getPosition() != 12 && this.tabIndex == this.tabPane.getTabCount() - 1) {
            this.setPosition(12);
            this.setReferencePoint(new Point(10, rectangle.height / 2));
        }
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle);
        if (!this.tabPane.getVisibleRect().contains(point)) {
            cloneable = this.tabPane.getVisibleRect();
            Rectangle rectangle2 = new Rectangle(point.x - ((Rectangle)cloneable).width / 2, point.y - ((Rectangle)cloneable).height / 2, ((Rectangle)cloneable).width, ((Rectangle)cloneable).height);
            this.tabPane.scrollRectToVisible(rectangle2);
        }
        cloneable = this.tabPane.getLocationOnScreen();
        ((Point)cloneable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)cloneable);
        return true;
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (super.consume(aWTEvent)) {
            return true;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        JTabbedPane jTabbedPane = (JTabbedPane)mouseEvent.getSource();
        this.setSource(jTabbedPane);
        this.setModifiers(mouseEvent.getModifiers());
        this.setNumberOfClicks(mouseEvent.getClickCount());
        this.setPopupTrigger(mouseEvent.isPopupTrigger());
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        Point point2 = jTabbedPane.getLocationOnScreen();
        point2.translate(point.x, point.y);
        this.setLocationOnScreen(point2);
        int n = ((BasicTabbedPaneUI)jTabbedPane.getUI()).tabForCoordinate(jTabbedPane, mouseEvent.getX(), mouseEvent.getY());
        this.setTitle(jTabbedPane.getTitleAt(n));
        this.setPosition(0);
        this.setReferencePoint(null);
        this.setValid(true);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        return aWTEvent.getSource() instanceof JTabbedPane && super.canConsume(aWTEvent) && this.sameSource(aWTEvent);
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" title: " + this.getTitle());
        stringBuffer.append(" index: " + this.getTabIndex());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof JTabbedPaneMouseEventData)) {
            return false;
        }
        JTabbedPaneMouseEventData jTabbedPaneMouseEventData = (JTabbedPaneMouseEventData)object;
        return super.equals(object) && jTabbedPaneMouseEventData.getTabIndex() == this.getTabIndex() && jTabbedPaneMouseEventData.getTitle() == this.getTitle();
    }
}

