/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.Iterator;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;
import junit.extensions.jfcunit.eventdata.DragEventData;
import junit.extensions.jfcunit.eventdata.EventDataConstants;
import junit.extensions.jfcunit.eventdata.JFCEventDataListener;

public class JFCEventManager
implements AWTEventListener,
EventDataConstants {
    public static final String EVENT_MAPPING_PROPERTY = "junit.extensions.jfcUnit.eventMapping";
    public static final String EVENT_DEBUG = "JFCEventManager.debug";
    private static JFCEventManager singleton;
    private static boolean debug;
    public static final int DEBUG_INPUT = 1;
    public static final int DEBUG_OUTPUT = 2;
    public static final int DEBUG_CREATE = 4;
    public static final int DEBUG_ALL = 7;
    private static int debug_type;
    private boolean recording = false;
    private AbstractEventData pendingEvent = null;
    private Thread timerThread;
    private volatile long lastEventTime = 0L;
    private long holdTime;
    private EventListenerList listenerList = new EventListenerList();
    static /* synthetic */ Class class$java$awt$AWTEvent;
    static /* synthetic */ Class class$junit$extensions$jfcunit$eventdata$JFCEventDataListener;
    static /* synthetic */ Class class$java$lang$Object;

    public static JFCEventManager getEventManager() {
        return JFCEventManager.getEventManager(100L);
    }

    public static JFCEventManager getEventManager(long l) {
        if (singleton == null) {
            singleton = new JFCEventManager(l);
        }
        return singleton;
    }

    public static void setDebug(boolean bl) {
        debug = bl;
        UIManager.put(EVENT_DEBUG, bl ? "true" : "false");
    }

    public static boolean getDebug() {
        Boolean bl = null;
        Object object = UIManager.get(EVENT_DEBUG);
        if (object instanceof Boolean) {
            bl = (Boolean)object;
        } else if (object instanceof String) {
            bl = new Boolean((String)object);
        }
        debug = bl == null ? true : bl;
        return debug;
    }

    public static void setDebugType(int n) {
        debug_type = n;
    }

    public static int getDebugType() {
        return debug_type;
    }

    public static void setRecording(boolean bl) {
        JFCEventManager.getEventManager().setRecordingImpl(bl);
    }

    private JFCEventManager(long l) {
        this.setHoldTime(l);
    }

    public final void setHoldTime(long l) {
        this.holdTime = l;
    }

    public final long getHoldTime() {
        return this.holdTime;
    }

    private void setRecordingImpl(boolean bl) {
        if (bl && !this.recording) {
            JFCEventManager.getDebug();
            long l = 0L;
            try {
                l = (class$java$awt$AWTEvent == null ? (class$java$awt$AWTEvent = JFCEventManager.class$("java.awt.AWTEvent")) : class$java$awt$AWTEvent).getField("MOUSE_WHEEL_EVENT_MASK").getLong(null);
            }
            catch (Exception exception) {
                l = 0L;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 0x438L | l);
            this.timerThread = new Thread(new Runnable(){

                public void run() {
                    while (JFCEventManager.this.recording) {
                        try {
                            Thread.currentThread();
                            Thread.sleep(JFCEventManager.this.holdTime);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        JFCEventManager jFCEventManager = JFCEventManager.this;
                        synchronized (jFCEventManager) {
                            long l = System.currentTimeMillis();
                            if (JFCEventManager.this.lastEventTime == 0L) {
                                JFCEventManager.this.lastEventTime = System.currentTimeMillis();
                            }
                            if (JFCEventManager.this.pendingEvent != null && l - JFCEventManager.this.lastEventTime > JFCEventManager.this.holdTime) {
                                JFCEventManager.this.fireEventData();
                            }
                        }
                    }
                    if (JFCEventManager.this.pendingEvent != null) {
                        JFCEventManager.this.fireEventData();
                    }
                }
            });
            this.timerThread.start();
            this.recording = bl;
        } else if (!bl && this.recording) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
            this.recording = bl;
            this.timerThread.interrupt();
            try {
                this.timerThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.recording = bl;
    }

    public final boolean getRecording() {
        return this.recording;
    }

    public final void addJFCEventDataListener(JFCEventDataListener jFCEventDataListener) {
        this.listenerList.add(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener = JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener")) : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, jFCEventDataListener);
    }

    public final void removeJFCEventDataListener(JFCEventDataListener jFCEventDataListener) {
        this.listenerList.remove(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener = JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener")) : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, jFCEventDataListener);
    }

    public final void removeAllJFCEventDataListeners() {
        Object[] objectArray = this.listenerList.getListenerList();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener)) {
                this.listenerList.remove(class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener, (EventListener)objectArray[n + 1]);
            }
            n += 2;
        }
    }

    protected final void fireEventData() {
        if (this.pendingEvent != null && this.pendingEvent.isValid()) {
            if (debug && (debug_type & 2) > 0) {
                System.err.println("JFCEventManager.outputEvent:" + this.pendingEvent);
            }
            Object[] objectArray = this.listenerList.getListenerList();
            int n = objectArray.length - 2;
            while (n >= 0) {
                if (objectArray[n] == (class$junit$extensions$jfcunit$eventdata$JFCEventDataListener == null ? JFCEventManager.class$("junit.extensions.jfcunit.eventdata.JFCEventDataListener") : class$junit$extensions$jfcunit$eventdata$JFCEventDataListener)) {
                    ((JFCEventDataListener)objectArray[n + 1]).handleEvent(this.pendingEvent);
                }
                n -= 2;
            }
        }
        this.pendingEvent = null;
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        this.processEventData(aWTEvent);
    }

    protected synchronized void processEventData(AWTEvent aWTEvent) {
        if (debug && (debug_type & 1) > 0) {
            System.err.println("JFCEventManager.inputEvent:" + ((InputEvent)aWTEvent).getWhen() + " " + aWTEvent);
        }
        this.lastEventTime = System.currentTimeMillis();
        if (aWTEvent instanceof MouseEvent && ((MouseEvent)aWTEvent).getID() == 503) {
            this.fireEventData();
            return;
        }
        if (this.pendingEvent != null && !this.pendingEvent.canConsume(aWTEvent) && !this.convertDrag(aWTEvent)) {
            this.fireEventData();
        }
        if (this.pendingEvent == null) {
            this.pendingEvent = this.createEvent(aWTEvent);
        }
        if (this.pendingEvent != null) {
            this.pendingEvent.consume(aWTEvent);
            this.lastEventTime = 0L;
        }
    }

    public boolean convertDrag(AWTEvent aWTEvent) {
        if (!(this.pendingEvent instanceof AbstractMouseEventData) || !(aWTEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() != 506) {
            return false;
        }
        this.pendingEvent = new DragEventData(null, (AbstractMouseEventData)this.pendingEvent);
        return true;
    }

    public AbstractEventData createEvent(AWTEvent aWTEvent) {
        Object object = aWTEvent.getSource();
        String string = object.getClass().getName();
        ArrayList arrayList = (ArrayList)UIManager.get(EVENT_MAPPING_PROPERTY);
        Iterator iterator = ((AbstractList)arrayList).iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            Class<Object> clazz = null;
            try {
                clazz = !stringArray[1].equals("*") ? Class.forName(stringArray[1]) : (class$java$lang$Object == null ? JFCEventManager.class$("java.lang.Object") : class$java$lang$Object);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!clazz.isInstance(object)) continue;
            try {
                Class<?> clazz2;
                AbstractEventData abstractEventData;
                if (debug && (debug_type & 4) > 0) {
                    System.err.println("JFCEventManager.createEvent check class:" + stringArray[0] + " can handle " + aWTEvent);
                }
                if (!(abstractEventData = (AbstractEventData)(clazz2 = Class.forName(stringArray[0])).newInstance()).canConsume(aWTEvent)) continue;
                return abstractEventData;
            }
            catch (Exception exception) {
                System.err.println("Exception attempting to create instnce for:" + stringArray[0]);
                exception.printStackTrace();
            }
        }
        if (debug && (debug_type & 4) > 0) {
            System.err.println("JFCEventManager.createEvent No EventData structure for:" + aWTEvent);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        if (UIManager.get(EVENT_MAPPING_PROPERTY) == null) {
            ArrayList<String[]> arrayList = new ArrayList<String[]>();
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JComboBoxMouseEventData", "javax.swing.JList"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JListMouseEventData", "javax.swing.JList"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JTableMouseEventData", "javax.swing.JTable"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JTableHeaderMouseEventData", "javax.swing.table.JTableHeader"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JTreeMouseEventData", "javax.swing.JTree"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JTabbedPaneMouseEventData", "javax.swing.JTabbedPane"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.JTextComponentMouseEventData", "javax.swing.text.JTextComponent"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.MouseWheelEventData", "*"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.MouseEventData", "*"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.StringEventData", "*"});
            arrayList.add(new String[]{"junit.extensions.jfcunit.eventdata.KeyEventData", "*"});
            UIManager.put(EVENT_MAPPING_PROPERTY, arrayList);
        }
        singleton = null;
        debug = false;
        debug_type = 7;
    }
}

