/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Vector;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.eventdata.AbstractMouseEventData;

public class DragEventData
extends AbstractEventData {
    private AbstractMouseEventData source;
    private AbstractMouseEventData dest;
    private Vector points = new Vector();

    public DragEventData(JFCTestCase jFCTestCase, AbstractMouseEventData abstractMouseEventData) {
        this(jFCTestCase, abstractMouseEventData, null, 300L);
    }

    public DragEventData(JFCTestCase jFCTestCase, AbstractMouseEventData abstractMouseEventData, AbstractMouseEventData abstractMouseEventData2) {
        this(jFCTestCase, abstractMouseEventData, abstractMouseEventData2, 300L);
    }

    public DragEventData(JFCTestCase jFCTestCase, AbstractMouseEventData abstractMouseEventData, AbstractMouseEventData abstractMouseEventData2, long l) {
        this.setTestCase(jFCTestCase);
        this.setSource(abstractMouseEventData);
        this.setDest(abstractMouseEventData2);
        this.setSleepTime(l);
        if (this.getSource() != null && this.getSource().isValid()) {
            this.setValid(true);
        }
    }

    public AbstractMouseEventData getSource() {
        return this.source;
    }

    public void setSource(AbstractMouseEventData abstractMouseEventData) {
        this.source = abstractMouseEventData;
    }

    public AbstractMouseEventData getDest() {
        return this.dest;
    }

    public void setDest(AbstractMouseEventData abstractMouseEventData) {
        this.dest = abstractMouseEventData;
    }

    public Component getComponent() {
        return null;
    }

    public boolean prepareComponent() throws Exception {
        boolean bl = true;
        boolean bl2 = true;
        if (this.source != null) {
            bl = this.source.prepareComponent();
            this.points.add(0, this.source.getLocationOnScreen());
        }
        if (this.dest != null) {
            bl2 = this.dest.prepareComponent();
            this.points.add(this.dest.getLocationOnScreen());
        }
        return bl & bl2;
    }

    public void addPoint(Point point) {
        this.points.add(point);
    }

    public Point[] getPoints() {
        return this.points.toArray(new Point[0]);
    }

    public void setPoints(Point[] pointArray) {
        this.points.clear();
        int n = 0;
        while (n < pointArray.length) {
            this.points.add(pointArray[n]);
            ++n;
        }
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() == 504 || mouseEvent.getID() == 505) {
            return true;
        }
        if (mouseEvent.getID() != 506) {
            return this.getSource().consume(aWTEvent);
        }
        Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
        this.addPoint(point);
        return true;
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() == 506 || mouseEvent.getID() == 505 || mouseEvent.getID() == 504) {
            return true;
        }
        if (this.isValid()) {
            return this.getSource().canConsume(aWTEvent);
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append("DragEventData:");
        if (!this.isValid()) {
            stringBuffer.append(" invalid");
            return stringBuffer.toString();
        }
        stringBuffer.append("(Source:" + this.getSource().toString() + ")");
        stringBuffer.append("Points:");
        int n = 0;
        while (n < this.points.size()) {
            if (n != 0) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.points.get(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof DragEventData)) {
            return false;
        }
        DragEventData dragEventData = (DragEventData)object;
        if (this.source == null ? dragEventData.getSource() != null : !this.source.equals(dragEventData.getSource())) {
            return false;
        }
        return !(this.dest == null ? dragEventData.getDest() != null : !this.dest.equals(dragEventData.getDest()));
    }
}

