/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import junit.extensions.jfcunit.eventdata.AbstractEventData;

public abstract class AbstractMouseEventData
extends AbstractEventData {
    private int numberOfClicks = 0;
    private boolean isPopupTrigger;

    public static int getDefaultModifiers(boolean bl) {
        return bl ? 4 : 16;
    }

    public void setNumberOfClicks(int n) {
        this.numberOfClicks = n;
    }

    public int getNumberOfClicks() {
        return this.numberOfClicks;
    }

    public void setPopupTrigger(boolean bl) {
        this.isPopupTrigger = bl;
    }

    public boolean getPopupTrigger() {
        return this.isPopupTrigger;
    }

    public boolean consume(AWTEvent aWTEvent) {
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        int n = mouseEvent.getID();
        return n == 503 || n == 504 || n == 505 || this.isValid() && aWTEvent.getSource() == this.getRoot();
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)aWTEvent;
        if (mouseEvent.getID() == 506) {
            return false;
        }
        return !aWTEvent.getSource().equals(this.getRoot((Component)aWTEvent.getSource()));
    }

    public boolean sameSource(AWTEvent aWTEvent) {
        if (this.isValid()) {
            return (Component)aWTEvent.getSource() == this.getComponent();
        }
        return true;
    }

    public String toString() {
        if (!this.isValid()) {
            return super.toString();
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(super.toString());
        stringBuffer.append(" clicks: " + this.getNumberOfClicks());
        stringBuffer.append(" popup: " + this.getPopupTrigger());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractMouseEventData)) {
            return false;
        }
        AbstractMouseEventData abstractMouseEventData = (AbstractMouseEventData)object;
        return super.equals(abstractMouseEventData) && abstractMouseEventData.getNumberOfClicks() == this.getNumberOfClicks() && abstractMouseEventData.getPopupTrigger() == this.getPopupTrigger();
    }
}

