/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.util.Arrays;
import java.util.Vector;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.eventdata.AbstractEventData;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;
import junit.extensions.jfcunit.keyboard.KeyMapping;

public abstract class AbstractKeyEventData
extends AbstractEventData {
    private final Vector keyStrokes = new Vector();
    private static final Object LOCK = new Object();
    private static KeyMapping keyMapping = null;

    public final JFCKeyStroke[] getKeyStrokes() {
        return this.keyStrokes.toArray(new JFCKeyStroke[0]);
    }

    protected final void clearKeyStrokes() {
        this.keyStrokes.clear();
    }

    protected final void addKeyStrokes(JFCKeyStroke[] jFCKeyStrokeArray) {
        int n = 0;
        while (n < jFCKeyStrokeArray.length) {
            this.keyStrokes.add(jFCKeyStrokeArray[n]);
            ++n;
        }
    }

    protected final void applyModifier(int n) {
        int n2 = 0;
        while (n2 < this.keyStrokes.size()) {
            JFCKeyStroke jFCKeyStroke = (JFCKeyStroke)this.keyStrokes.get(n2);
            int n3 = jFCKeyStroke.getModifiers() | n;
            jFCKeyStroke.setModifiers(n3);
            ++n2;
        }
    }

    public static void setKeyMapping(KeyMapping keyMapping) {
        TestHelper.setKeyMapping(keyMapping);
    }

    public static KeyMapping getKeyMapping() {
        return TestHelper.getKeyMapping();
    }

    public boolean consume(AWTEvent aWTEvent) {
        if (!(aWTEvent instanceof KeyEvent)) {
            return false;
        }
        KeyEvent keyEvent = (KeyEvent)aWTEvent;
        int n = keyEvent.getID();
        return n == 400 || n == 402 || this.isMetaChar(keyEvent.getKeyCode()) || aWTEvent.getSource().equals(this.getRoot());
    }

    public boolean canConsume(AWTEvent aWTEvent) {
        if (!this.isValid()) {
            return true;
        }
        return aWTEvent instanceof KeyEvent && this.getRoot((Component)aWTEvent.getSource()).equals(this.getRoot());
    }

    public boolean equals(Object object) {
        if (!super.equals(object) || !(object instanceof AbstractKeyEventData)) {
            return false;
        }
        AbstractKeyEventData abstractKeyEventData = (AbstractKeyEventData)object;
        Object[] objectArray = abstractKeyEventData.getKeyStrokes();
        Object[] objectArray2 = this.getKeyStrokes();
        return Arrays.equals(objectArray, objectArray2);
    }
}

