/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit.eventdata;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import junit.extensions.jfcunit.JFCTestCase;
import junit.extensions.jfcunit.eventdata.EventDataConstants;

public abstract class AbstractEventData
implements EventDataConstants {
    private JFCTestCase testCase;
    private int modifiers;
    private long sleepTime;
    private int position;
    private Point referencePoint;
    private Point screenLocation;
    private boolean valid;

    public void setTestCase(JFCTestCase jFCTestCase) {
        this.testCase = jFCTestCase;
    }

    public JFCTestCase getTestCase() {
        return this.testCase;
    }

    public void setModifiers(int n) {
        this.modifiers = n;
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public long getSleepTime() {
        return this.sleepTime;
    }

    protected boolean isValidForProcessing(Component component) {
        return component != null && component.isShowing();
    }

    public abstract Component getComponent();

    public Component getRoot() {
        return this.getRoot(this.getComponent());
    }

    public Component getRoot(Component component) {
        return SwingUtilities.getRoot(component);
    }

    public void setReferencePoint(Point point) {
        this.referencePoint = point;
    }

    public Point getReferencePoint() {
        return this.referencePoint;
    }

    public void setPosition(int n) {
        this.position = n;
    }

    public int getPosition() {
        return this.position;
    }

    public final Point getLocationOnScreen() {
        return this.screenLocation;
    }

    protected final void setLocationOnScreen(Point point) {
        this.screenLocation = point;
    }

    public void requestFocus(Component component) {
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        if (component != null) {
            component.requestFocus();
        }
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
    }

    protected Point calculatePoint(Rectangle rectangle) {
        if (this.position == 12) {
            return new Point(rectangle.x + this.referencePoint.x, rectangle.y + this.referencePoint.y);
        }
        int n = 0;
        int n2 = 0;
        if (this.position == 13) {
            n = rectangle.x + rectangle.width * this.referencePoint.x / 100;
            n2 = rectangle.y + rectangle.height * this.referencePoint.y / 100;
        } else {
            n2 = this.position == 1 || this.position == 8 || this.position == 2 ? rectangle.y : (this.position == 5 || this.position == 6 || this.position == 4 ? rectangle.y + rectangle.height : rectangle.y + rectangle.height / 2);
            n = this.position == 7 || this.position == 8 || this.position == 6 ? rectangle.x : (this.position == 3 || this.position == 2 || this.position == 4 ? rectangle.x + rectangle.width : rectangle.x + rectangle.width / 2);
        }
        return new Point(n, n2);
    }

    public boolean prepareComponent() throws Exception {
        Serializable serializable;
        Rectangle rectangle;
        if (!this.isValidForProcessing(this.getComponent())) {
            return false;
        }
        this.requestFocus(this.getComponent());
        JFCTestCase jFCTestCase = this.getTestCase();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Rectangle rectangle2 = this.getComponent().getBounds();
        if (jFCTestCase != null) {
            jFCTestCase.flushAWT();
        }
        Point point = this.calculatePoint(rectangle2);
        if (this.getComponent() instanceof JComponent && !(rectangle = ((JComponent)(serializable = (JComponent)this.getComponent())).getVisibleRect()).contains(point)) {
            Rectangle rectangle3 = new Rectangle(point.x - rectangle.width / 2, point.y - rectangle.height / 2, rectangle.width, rectangle.height);
            ((JComponent)serializable).scrollRectToVisible(rectangle3);
        }
        serializable = this.getComponent().getLocationOnScreen();
        ((Point)serializable).translate(point.x, point.y);
        this.setLocationOnScreen((Point)serializable);
        return true;
    }

    public abstract boolean consume(AWTEvent var1);

    protected boolean canConsume(AWTEvent aWTEvent) {
        if (!this.isValid()) {
            return true;
        }
        return aWTEvent.getSource().equals(this.getComponent());
    }

    public boolean isMetaChar(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 144: 
            case 157: 
            case 65406: {
                return true;
            }
        }
        return false;
    }

    public void setValid(boolean bl) {
        this.valid = bl;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(1000);
        stringBuffer.append(this.getClass().getName());
        if (!this.isValid()) {
            stringBuffer.append(" invalid");
            return stringBuffer.toString();
        }
        stringBuffer.append(" testCase: " + (Object)((Object)this.testCase));
        stringBuffer.append(" modifiers: " + this.modifiers);
        stringBuffer.append(" sleepTime: " + this.sleepTime);
        stringBuffer.append(" position:" + EventDataConstants.POSITIONSTRINGS[this.position]);
        stringBuffer.append(" refPoint: " + this.referencePoint);
        stringBuffer.append(" screenLoc: " + this.screenLocation);
        stringBuffer.append(" component: " + this.getComponent());
        return stringBuffer.toString();
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof AbstractEventData)) {
            return false;
        }
        AbstractEventData abstractEventData = (AbstractEventData)object;
        return abstractEventData.isValid() == this.isValid() && abstractEventData.getComponent() == this.getComponent() && abstractEventData.getModifiers() == this.getModifiers() && abstractEventData.getPosition() == this.getPosition() && abstractEventData.getReferencePoint() == this.getReferencePoint();
    }
}

