/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.WindowEvent;
import java.util.Vector;
import junit.extensions.jfcunit.ExitException;

public class WindowMonitor
implements AWTEventListener {
    private static WindowMonitor singleton = null;
    private static DispatchThread dt = null;
    private static WindowEventItem windowEventQueue = null;
    private static final Object QLOCK = new Object();
    private static final Vector WINDOWS = new Vector();
    private static final Vector POPUPS = new Vector();

    private static final Window[] filterWindows(Vector vector) {
        WindowMonitor.flushAWT();
        Window[] windowArray = new Window[vector.size()];
        Object object = QLOCK;
        synchronized (object) {
            windowArray = vector.toArray(windowArray);
            QLOCK.notifyAll();
        }
        return windowArray;
    }

    public static final Window[] getWindows() {
        return WindowMonitor.filterWindows(WINDOWS);
    }

    private static final WindowMonitor getSingleton() {
        if (singleton == null) {
            singleton = new WindowMonitor();
        }
        return singleton;
    }

    private WindowMonitor() {
        if (dt == null) {
            dt = new DispatchThread("WindowMonitor-DispatchThread");
            dt.start();
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 64L);
        }
    }

    public static final void start() {
        WindowMonitor.getSingleton();
    }

    public void eventDispatched(AWTEvent aWTEvent) {
        WindowMonitor.processEvent(aWTEvent);
    }

    private static final void processEvent(AWTEvent aWTEvent) {
        switch (aWTEvent.getID()) {
            case 200: 
            case 201: 
            case 205: 
            case 206: {
                WindowMonitor.queueWindowEvent((WindowEvent)aWTEvent);
                break;
            }
        }
    }

    private static void queueWindowEvent(WindowEvent windowEvent) {
        Object object = QLOCK;
        synchronized (object) {
            WindowEventItem windowEventItem = new WindowEventItem(windowEvent);
            if (windowEventQueue == null) {
                windowEventQueue = windowEventItem;
            } else {
                WindowEventItem windowEventItem2 = windowEventQueue;
                while (windowEventItem2.getNext() != null) {
                    windowEventItem2 = windowEventItem2.getNext();
                }
                windowEventItem2.setNext(windowEventItem);
            }
            QLOCK.notifyAll();
        }
    }

    private static void flushAWT() {
        try {
            Toolkit.getDefaultToolkit().getSystemEventQueue();
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class WindowEventItem {
        private WindowEvent event;
        private WindowEventItem next;

        public WindowEvent getEvent() {
            return this.event;
        }

        public WindowEventItem getNext() {
            return this.next;
        }

        public void setNext(WindowEventItem windowEventItem) {
            this.next = windowEventItem;
        }

        WindowEventItem(WindowEvent windowEvent) {
            this.event = windowEvent;
            this.next = null;
        }
    }

    private class DispatchThread
    extends Thread {
        public DispatchThread(String string) {
            super(string);
            this.setDaemon(true);
        }

        public void run() {
            WindowEvent windowEvent = null;
            while (true) {
                Object object;
                if (windowEventQueue == null) {
                    object = QLOCK;
                    synchronized (object) {
                        try {
                            QLOCK.wait();
                        }
                        catch (ExitException exitException) {
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                object = QLOCK;
                synchronized (object) {
                    windowEvent = windowEventQueue.getEvent();
                    windowEventQueue = windowEventQueue.getNext();
                    switch (windowEvent.getID()) {
                        case 200: 
                        case 205: 
                        case 206: {
                            if (WINDOWS.contains(windowEvent.getWindow())) break;
                            WINDOWS.add(windowEvent.getWindow());
                            break;
                        }
                        case 201: {
                            WINDOWS.remove(windowEvent.getWindow());
                        }
                    }
                    try {
                        QLOCK.notifyAll();
                    }
                    catch (ExitException exitException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

