/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.keyboard.JFCKeyStroke;

public class JFCTestHelper
extends TestHelper {
    private int lastX = 0;
    private int lastY = 0;
    private long lastPressed = 0L;
    private int lastMouseModifiers = 0;
    private boolean lastPopup = false;
    private int lastClicks;
    private EventQueue queue = Toolkit.getDefaultToolkit().getSystemEventQueue();
    static /* synthetic */ Class class$java$awt$Component;

    protected void keyPressed(Component component, JFCKeyStroke jFCKeyStroke) {
        this.postEvent(new KeyEvent(component, 401, System.currentTimeMillis(), jFCKeyStroke.getModifiers(), jFCKeyStroke.getKeyCode(), jFCKeyStroke.getKeyChar()));
    }

    protected void keyReleased(Component component, JFCKeyStroke jFCKeyStroke) {
        if (jFCKeyStroke.isTyped()) {
            this.postEvent(new KeyEvent(component, 400, System.currentTimeMillis(), jFCKeyStroke.getModifiers(), 0, jFCKeyStroke.getKeyChar()));
        }
        this.postEvent(new KeyEvent(component, 402, System.currentTimeMillis(), jFCKeyStroke.getModifiers(), jFCKeyStroke.getKeyCode(), jFCKeyStroke.getKeyChar()));
    }

    protected void mouseMoved(Component component, int n, int n2) {
        int n3 = n - component.getLocationOnScreen().x;
        int n4 = n2 - component.getLocationOnScreen().y;
        int n5 = this.lastX < n3 ? 1 : -1;
        int n6 = this.lastY < n4 ? 1 : -1;
        int n7 = this.lastPressed == 0L ? 503 : 506;
        while (this.lastX != n3 || this.lastY != n4) {
            this.lastX = this.lastX == n3 ? n3 : this.lastX + n5;
            this.lastY = this.lastY == n4 ? n4 : this.lastY + n6;
            this.postEvent(new MouseEvent(component, n7, System.currentTimeMillis(), this.lastMouseModifiers, this.lastX, this.lastY, 0, this.lastPopup));
        }
    }

    protected void mousePressed(Component component, int n, int n2, boolean bl) {
        this.lastPressed = System.currentTimeMillis();
        this.lastPopup = bl;
        this.lastMouseModifiers = n;
        if (n != 0) {
            this.postEvent(new MouseEvent(component, 501, this.lastPressed, n, this.lastX, this.lastY, n2, bl));
        }
    }

    protected void mouseReleased(Component component, int n, int n2, boolean bl) {
        this.lastMouseModifiers = n;
        this.lastPopup = bl;
        this.lastClicks = n2;
        if (n != 0) {
            this.postEvent(new MouseEvent(component, 502, System.currentTimeMillis(), n, this.lastX, this.lastY, n2, bl));
            long l = this.lastPressed - System.currentTimeMillis();
            if (n2 > 0 && l < 100L) {
                this.postEvent(new MouseEvent(component, 500, System.currentTimeMillis(), n, this.lastX, this.lastY, n2, bl));
            }
        }
        this.lastPressed = 0L;
    }

    protected void mouseWheel(Component component, int n, int n2) throws Exception {
        Class<?> clazz = Class.forName("java.awt.event.MouseWheelEvent");
        Constructor<?> constructor = clazz.getConstructor(class$java$awt$Component == null ? (class$java$awt$Component = JFCTestHelper.class$("java.awt.Component")) : class$java$awt$Component, Integer.TYPE, Long.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
        int n3 = 0;
        int n4 = clazz.getField("MOUSE_WHEEL").getInt(null);
        n3 = (this.lastMouseModifiers & 1) > 1 ? clazz.getField("WHEEL_BLOCK_SCROLL").getInt(null) : clazz.getField("WHEEL_UNIT_SCROLL").getInt(null);
        this.postEvent((AWTEvent)constructor.newInstance(component, new Integer(n4), new Long(System.currentTimeMillis()), new Integer(this.lastMouseModifiers), new Integer(this.lastX), new Integer(this.lastY), new Integer(this.lastClicks), new Boolean(this.lastPopup), new Integer(n3), new Integer(n), new Integer(n2)));
    }

    private void postEvent(AWTEvent aWTEvent) {
        this.queue.postEvent(aWTEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

