/*
 * Decompiled with CFR 0.152.
 */
package junit.extensions.jfcunit;

import java.awt.EventQueue;
import java.awt.Toolkit;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.Permission;
import junit.extensions.jfcunit.ExitException;
import junit.extensions.jfcunit.TestHelper;
import junit.extensions.jfcunit.WindowMonitor;
import junit.framework.Assert;
import junit.framework.TestCase;

public class JFCTestCase
extends TestCase {
    private static final long LOCKWAIT = 25L;
    private static final long DEFAULTSLEEP = 100L;
    private boolean forcedWait = false;
    private boolean cont = false;
    private volatile boolean pausingAWT = false;
    private Throwable err;
    private Object lock = new Object();
    private long sleepTime = 100L;
    private volatile boolean waiting = false;
    protected TestHelper helper;

    public JFCTestCase() {
    }

    public JFCTestCase(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void setHelper(TestHelper testHelper) {
        this.helper = testHelper;
    }

    public TestHelper getHelper() {
        return this.helper;
    }

    protected void setForcedWait(boolean bl) {
        this.forcedWait = bl;
    }

    protected void resetForcedWait() {
        this.forcedWait = false;
    }

    public void setSleepTime(long l) {
        this.sleepTime = l;
    }

    public void resetSleepTime() {
        this.sleepTime = 100L;
    }

    private long getSleepTime() {
        return this.sleepTime;
    }

    private void setContinue(boolean bl) {
        this.cont = bl;
    }

    private boolean getContinue() {
        return this.cont;
    }

    protected void setError(Throwable throwable) {
        this.err = throwable;
    }

    protected void resetError() {
        this.setError(null);
    }

    protected boolean hasError() {
        return this.err != null && !(this.err instanceof ExitException);
    }

    protected Throwable getError() {
        return this.err;
    }

    public final void awtSleep() {
        this.release();
        try {
            this.acquire();
        }
        catch (ExitException exitException) {
            this.setError(exitException);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public final void awtSleep(long l) {
        this.setSleepTime(l);
        this.awtSleep();
    }

    public final void sleep(long l) {
        long l2 = System.currentTimeMillis() + l;
        l2 += l;
        while (System.currentTimeMillis() < l2) {
            this.release();
            try {
                Thread.currentThread();
                Thread.sleep(25L);
                this.acquire();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void release() {
        try {
            this.lock.notify();
        }
        catch (ExitException exitException) {
            // empty catch block
        }
    }

    private void acquire() throws InterruptedException {
        try {
            if (this.pausingAWT) {
                this.lock.wait();
            } else {
                this.lock.wait(25L);
            }
        }
        catch (ExitException exitException) {
            // empty catch block
        }
    }

    public final void pauseAWT() {
        this.pausingAWT = true;
        this.awtSleep();
    }

    public final void resumeAWT() {
        this.awtSleep();
        this.pausingAWT = false;
        this.awtSleep();
    }

    public final void flushAWT() {
        this.pauseAWT();
        this.resumeAWT();
    }

    public boolean isAWTRunning() {
        return !this.pausingAWT;
    }

    protected void runTest() throws Throwable {
        Method method;
        try {
            method = ((Object)((Object)this)).getClass().getMethod(this.getName(), new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Assert.fail((String)("Method \"" + this.getName() + "\" not found"));
            return;
        }
        if (method != null && !Modifier.isPublic(method.getModifiers())) {
            Assert.fail((String)("Method \"" + this.getName() + "\" should be public"));
            return;
        }
        this.runCode(new Runnable(){

            public void run() {
                try {
                    method.invoke((Object)JFCTestCase.this, new Object[0]);
                    JFCTestCase.this.flushAWT();
                }
                catch (ExitException exitException) {
                    JFCTestCase.this.setError(exitException);
                }
                catch (InvocationTargetException invocationTargetException) {
                    JFCTestCase.this.setError(invocationTargetException.getTargetException());
                }
                catch (IllegalAccessException illegalAccessException) {
                    JFCTestCase.this.setError(illegalAccessException);
                }
            }
        });
    }

    public void runBare() throws Throwable {
        SecurityManager securityManager = System.getSecurityManager();
        System.setSecurityManager(this.createNoExitSecurityManager());
        try {
            try {
                this.runCode(new Runnable(){

                    public void run() {
                        try {
                            JFCTestCase.this.setUp();
                            JFCTestCase.this.flushAWT();
                        }
                        catch (ExitException exitException) {
                            JFCTestCase.this.setError(exitException);
                        }
                        catch (Exception exception) {
                            JFCTestCase.this.setError(exception);
                        }
                    }
                });
                try {
                    this.runTest();
                }
                catch (ExitException exitException) {
                    this.setError(exitException);
                }
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                this.runCode(new Runnable(){

                    public void run() {
                        try {
                            JFCTestCase.this.resumeAWT();
                            JFCTestCase.this.tearDown();
                            JFCTestCase.this.flushAWT();
                        }
                        catch (ExitException exitException) {
                            JFCTestCase.this.setError(exitException);
                        }
                        catch (Exception exception) {
                            JFCTestCase.this.setError(exception);
                        }
                    }
                });
                throw throwable;
            }
            this.runCode(new /* invalid duplicate definition of identical inner class */);
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            System.setSecurityManager(securityManager);
            throw throwable;
        }
        System.setSecurityManager(securityManager);
    }

    protected synchronized void runCode(final Runnable runnable) throws Throwable {
        this.waiting = false;
        this.setContinue(true);
        this.resetError();
        new Thread(new Runnable(){

            public void run() {
                Object object = JFCTestCase.this.lock;
                synchronized (object) {
                    JFCTestCase.this.waiting = true;
                    try {
                        JFCTestCase.this.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    try {
                        runnable.run();
                    }
                    catch (ExitException exitException) {
                        JFCTestCase.this.setError(exitException);
                    }
                    JFCTestCase.this.setContinue(false);
                    JFCTestCase.this.release();
                }
            }
        }, this.getName()).start();
        while (!this.waiting) {
            try {
                Thread.currentThread();
                Thread.sleep(25L);
            }
            catch (ExitException exitException) {
                this.setError(exitException);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        boolean bl = false;
        boolean bl2 = true;
        long l = 0L;
        do {
            if (bl2 && this.pausingAWT) {
                Toolkit.getDefaultToolkit().getSystemEventQueue();
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        Object object = JFCTestCase.this.lock;
                        synchronized (object) {
                            JFCTestCase.this.release();
                            try {
                                JFCTestCase.this.acquire();
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
                if (this.forcedWait) {
                    bl2 = false;
                }
            }
            try {
                l += 25L;
                Thread.currentThread();
                Thread.sleep(25L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (bl = this.forcedWait ? l <= this.getSleepTime() : this.getContinue());
        if (this.hasError()) {
            throw this.getError();
        }
    }

    protected final SecurityManager createNoExitSecurityManager() {
        return new SecurityManager(){

            public void checkExit(int n) {
                throw new ExitException(n);
            }

            public void checkPermission(Permission permission) {
            }
        };
    }

    static {
        WindowMonitor.start();
    }
}

