/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jumpto.common;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.NullUnknown;
import org.netbeans.modules.jumpto.common.Factory;
import org.netbeans.modules.jumpto.common.StateFullComparator;
import org.netbeans.spi.jumpto.support.AsyncDescriptor;
import org.netbeans.spi.jumpto.support.DescriptorChangeEvent;
import org.netbeans.spi.jumpto.support.DescriptorChangeListener;
import org.openide.util.ChangeSupport;
import org.openide.util.Pair;

public final class Models {
    private Models() {
    }

    public static <T> ListModel fromList(@NonNull List<? extends T> list, @NullAllowed Filter<? super T> filter, @NullAllowed Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier) {
        return new ListListModel<T>(list, filter, attrCopier);
    }

    public static <T, P> ListModel translating(ListModel model, Factory<T, P> factory) {
        return new TranslatingListModel<T, P>(model, factory);
    }

    public static <R, P> ListModel refreshable(@NonNull ListModel<P> model, @NonNull Factory<R, Pair<P, Runnable>> convertor) {
        return new RefreshableListModel<R, P>(model, convertor);
    }

    public static <T> MutableListModel<T> mutable(@NullAllowed Comparator<? super T> comparator, @NullAllowed Filter<? super T> filter, @NullAllowed Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier) {
        return new MutableListModelImpl<T>(comparator, filter, attrCopier);
    }

    @NonNull
    public static <T> Filter<T> chained(Filter<T> ... filters) {
        return new ChainedFilter<T>(filters);
    }

    @NonNull
    private static <T> Collection<? extends T> filter(@NullAllowed Filter<? super T> filter, @NonNull Collection<? extends T> c) {
        if (filter == null) {
            return c;
        }
        ArrayList<T> res = new ArrayList<T>(c.size());
        for (T item : c) {
            if (!filter.accept(item)) continue;
            res.add(item);
        }
        return res;
    }

    @NonNull
    private static <T> Collection<? extends T> copyAttrs(@NullAllowed Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier, @NonNull T source, @NonNull Collection<? extends T> c) {
        if (attrCopier != null) {
            for (T item : c) {
                T res = attrCopier.create(Pair.of(source, item));
                assert (res == item);
            }
        }
        return c;
    }

    @NullUnknown
    private static <T> T head(@NonNull Collection<? extends T> c) {
        if (c instanceof List) {
            return (T)((List)c).get(0);
        }
        return c.iterator().next();
    }

    @NonNull
    private static <T> Collection<? extends T> tail(@NonNull Collection<? extends T> c) {
        if (c instanceof List) {
            return ((List)c).subList(1, c.size());
        }
        ArrayList<T> res = new ArrayList<T>(c.size() - 1);
        boolean add = false;
        for (T item : c) {
            if (add) {
                res.add(item);
                continue;
            }
            add = true;
        }
        return res;
    }

    @NullUnknown
    private static <R> R invokeInEDT(final @NonNull Callable<R> call) {
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                return call.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            final AtomicReference res = new AtomicReference();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        res.set(call.call());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return (R)res.get();
        }
        catch (InterruptedException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class ChainedFilter<T>
    implements Filter<T>,
    ChangeListener {
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final Collection<Filter<T>> filters;

        ChainedFilter(Filter<T> ... filters) {
            this.filters = Arrays.asList(filters);
            for (Filter<T> filter : this.filters) {
                filter.addChangeListener(this);
            }
        }

        @Override
        public boolean accept(@NonNull T item) {
            for (Filter<T> filter : this.filters) {
                if (filter.accept(item)) continue;
                return false;
            }
            return true;
        }

        @Override
        public void addChangeListener(@NonNull ChangeListener listener) {
            this.changeSupport.addChangeListener(listener);
        }

        @Override
        public void remmoveChangeListener(@NonNull ChangeListener listener) {
            this.changeSupport.removeChangeListener(listener);
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent e) {
            this.changeSupport.fireChange();
        }
    }

    private static final class MutableListModelImpl<T>
    extends AbstractListModel<T>
    implements MutableListModel<T>,
    ChangeListener,
    DescriptorChangeListener<T> {
        private final Comparator<T> comparator;
        private final Filter<T> filter;
        private final Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier;
        private List<T> items;
        private List<T> included;

        MutableListModelImpl(@NullAllowed Comparator<T> comparator, @NullAllowed Filter<T> filter, @NullAllowed Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier) {
            this.comparator = comparator;
            this.filter = filter;
            this.attrCopier = attrCopier;
            this.included = Collections.emptyList();
            this.items = this.included;
            if (this.comparator instanceof StateFullComparator) {
                ((StateFullComparator)this.comparator).addChangeListener(this);
            }
            if (this.filter != null) {
                this.filter.addChangeListener(this);
            }
        }

        @Override
        public int getSize() {
            assert (SwingUtilities.isEventDispatchThread());
            return this.included.size();
        }

        @Override
        public T getElementAt(int index) {
            assert (SwingUtilities.isEventDispatchThread());
            return this.included.get(index);
        }

        @Override
        public void add(Collection<? extends T> values) {
            Pair<List<T>, List<T>> data;
            boolean success;
            for (T value : values) {
                if (!(value instanceof AsyncDescriptor)) continue;
                ((AsyncDescriptor)value).addDescriptorChangeListener(this);
            }
            do {
                data = this.getData();
                ((List)data.second()).addAll(values);
                if (this.comparator == null) continue;
                Collections.sort((List)data.second(), this.comparator);
            } while (!(success = this.casData((List)data.first(), (List)data.second())));
        }

        @Override
        public void remove(Collection<? extends T> values) {
            Pair<List<T>, List<T>> data;
            boolean success;
            for (T value : values) {
                if (!(value instanceof AsyncDescriptor)) continue;
                ((AsyncDescriptor)value).removeDescriptorChangeListener(this);
            }
            do {
                data = this.getData();
                ((List)data.second()).removeAll(values);
            } while (!(success = this.casData((List)data.first(), (List)data.second())));
        }

        @Override
        public void stateChanged(@NonNull ChangeEvent e) {
            Object source = e.getSource();
            if (source == this.comparator) {
                this.add(Collections.emptyList());
            } else if (source == this.filter) {
                this.filterData();
            }
        }

        @Override
        public void descriptorChanged(@NonNull DescriptorChangeEvent<T> event) {
            final Object source = event.getSource();
            final Collection replacement = Models.copyAttrs(this.attrCopier, source, Models.filter(this.filter, event.getReplacement()));
            ((AsyncDescriptor)source).removeDescriptorChangeListener(this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int listIndex = MutableListModelImpl.this.items.indexOf(source);
                    int includedIndex = MutableListModelImpl.this.included.indexOf(source);
                    if (listIndex >= 0) {
                        switch (replacement.size()) {
                            case 0: {
                                MutableListModelImpl.this.items.remove(listIndex);
                                if (includedIndex < 0) break;
                                if (MutableListModelImpl.this.included != MutableListModelImpl.this.items) {
                                    MutableListModelImpl.this.included.remove(includedIndex);
                                }
                                MutableListModelImpl.this.fireIntervalRemoved(MutableListModelImpl.this, includedIndex, includedIndex);
                                break;
                            }
                            case 1: {
                                Object item = Models.head(replacement);
                                MutableListModelImpl.this.items.set(listIndex, item);
                                if (includedIndex < 0) break;
                                if (MutableListModelImpl.this.included != MutableListModelImpl.this.items) {
                                    MutableListModelImpl.this.included.set(includedIndex, item);
                                }
                                MutableListModelImpl.this.fireContentsChanged(MutableListModelImpl.this, includedIndex, includedIndex);
                                break;
                            }
                            default: {
                                Object head = Models.head(replacement);
                                Collection tail = Models.tail(replacement);
                                MutableListModelImpl.this.items.set(listIndex, head);
                                MutableListModelImpl.this.items.addAll(listIndex + 1, tail);
                                if (includedIndex < 0) break;
                                if (MutableListModelImpl.this.included != MutableListModelImpl.this.items) {
                                    MutableListModelImpl.this.included.set(includedIndex, head);
                                    MutableListModelImpl.this.included.addAll(includedIndex + 1, tail);
                                }
                                MutableListModelImpl.this.fireContentsChanged(MutableListModelImpl.this, includedIndex, includedIndex);
                                MutableListModelImpl.this.fireIntervalAdded(MutableListModelImpl.this, includedIndex + 1, includedIndex + tail.size());
                            }
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        private Pair<List<T>, List<T>> getData() {
            return (Pair)Models.invokeInEDT(new Callable<Pair<List<T>, List<T>>>(){

                @Override
                public Pair<List<T>, List<T>> call() throws Exception {
                    assert (SwingUtilities.isEventDispatchThread());
                    ArrayList copy = new ArrayList(MutableListModelImpl.this.items);
                    return Pair.of((Object)MutableListModelImpl.this.items, copy);
                }
            });
        }

        private boolean casData(final List<T> expected, final List<T> update) {
            return (Boolean)Models.invokeInEDT(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    assert (SwingUtilities.isEventDispatchThread());
                    if (MutableListModelImpl.this.items == expected) {
                        int oldSize = MutableListModelImpl.this.items.size();
                        MutableListModelImpl.this.items = (MutableListModelImpl.this.included = update);
                        int newSize = MutableListModelImpl.this.items.size();
                        MutableListModelImpl.this.fireContentsChanged(this, 0, Math.max(0, Math.min(oldSize - 1, newSize - 1)));
                        if (oldSize < newSize) {
                            MutableListModelImpl.this.fireIntervalAdded(this, oldSize, newSize - 1);
                        } else if (oldSize > newSize) {
                            MutableListModelImpl.this.fireIntervalRemoved(this, newSize, oldSize - 1);
                        }
                        return true;
                    }
                    return false;
                }
            });
        }

        private void filterData() {
            if (this.filter != null) {
                Models.invokeInEDT(new Callable<Void>(){

                    @Override
                    public Void call() {
                        assert (SwingUtilities.isEventDispatchThread());
                        int oldSize = MutableListModelImpl.this.included.size();
                        ArrayList newIncluded = new ArrayList(MutableListModelImpl.this.items.size());
                        for (Object item : MutableListModelImpl.this.items) {
                            if (!MutableListModelImpl.this.filter.accept(item)) continue;
                            newIncluded.add(item);
                        }
                        MutableListModelImpl.this.included = newIncluded;
                        int newSize = MutableListModelImpl.this.included.size();
                        MutableListModelImpl.this.fireContentsChanged(this, 0, Math.max(0, Math.min(oldSize - 1, newSize - 1)));
                        if (oldSize < newSize) {
                            MutableListModelImpl.this.fireIntervalAdded(this, oldSize, newSize - 1);
                        } else if (oldSize > newSize) {
                            MutableListModelImpl.this.fireIntervalRemoved(this, newSize, oldSize - 1);
                        }
                        return null;
                    }
                });
            }
        }
    }

    private static final class RefreshableListModel<R, P>
    extends AbstractListModel
    implements ListDataListener {
        private final ListModel delegate;
        private final Factory<R, Pair<P, Runnable>> convertor;
        private final Map<P, R> cache;

        RefreshableListModel(@NonNull ListModel delegate, @NonNull Factory<R, Pair<P, Runnable>> convertor) {
            this.delegate = delegate;
            this.convertor = convertor;
            this.cache = new IdentityHashMap<P, R>();
            delegate.addListDataListener(this);
        }

        @Override
        public int getSize() {
            return this.delegate.getSize();
        }

        @Override
        public Object getElementAt(int index) {
            if (index < 0 || index >= this.delegate.getSize()) {
                throw new IllegalArgumentException(String.format("Invalid index: %d, model size: %d.", index, this.delegate.getSize()));
            }
            final Object orig = this.delegate.getElementAt(index);
            R result = this.cache.get(orig);
            if (result != null) {
                return result;
            }
            result = this.convertor.create(Pair.of(orig, (Object)new Runnable(){

                @Override
                public void run() {
                    int index = -1;
                    for (int i = 0; i < RefreshableListModel.this.delegate.getSize(); ++i) {
                        if (orig != RefreshableListModel.this.delegate.getElementAt(i)) continue;
                        index = i;
                        break;
                    }
                    if (index != -1) {
                        RefreshableListModel.this.fireContentsChanged(RefreshableListModel.this, index, index);
                    }
                }
            }));
            this.cache.put(orig, result);
            return result;
        }

        @Override
        public void intervalAdded(ListDataEvent e) {
            this.fireIntervalAdded(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void intervalRemoved(ListDataEvent e) {
            this.fireIntervalRemoved(this, e.getIndex0(), e.getIndex1());
        }

        @Override
        public void contentsChanged(ListDataEvent e) {
            this.fireContentsChanged(this, e.getIndex0(), e.getIndex1());
        }
    }

    private static class TranslatingListModel<T, P>
    implements ListModel {
        private Factory<T, P> factory;
        private ListModel listModel;

        public TranslatingListModel(ListModel model, Factory<T, P> factory) {
            this.listModel = model;
            this.factory = factory;
        }

        public T getElementAt(int index) {
            Object original = this.listModel.getElementAt(index);
            return this.factory.create(original);
        }

        @Override
        public int getSize() {
            return this.listModel.getSize();
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }
    }

    private static final class ListListModel<T>
    extends AbstractListModel
    implements ChangeListener,
    DescriptorChangeListener<T> {
        private final List<T> list;
        private final Filter<? super T> filter;
        private final Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier;
        private List<T> included;

        public ListListModel(@NonNull List<? extends T> list, @NullAllowed Filter<? super T> filter, @NullAllowed Factory<? extends T, Pair<? extends T, ? extends T>> attrCopier) {
            this.list = new ArrayList<T>(list.size());
            for (T item : list) {
                if (item instanceof AsyncDescriptor) {
                    ((AsyncDescriptor)item).addDescriptorChangeListener(this);
                }
                this.list.add(item);
            }
            this.included = this.list;
            this.filter = filter;
            if (this.filter != null) {
                this.filter.addChangeListener(this);
            }
            this.attrCopier = attrCopier;
        }

        @Override
        public T getElementAt(int index) {
            assert (SwingUtilities.isEventDispatchThread());
            return this.included.get(index);
        }

        @Override
        public int getSize() {
            assert (SwingUtilities.isEventDispatchThread());
            return this.included.size();
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            this.filterData();
        }

        @Override
        public void descriptorChanged(@NonNull DescriptorChangeEvent<T> event) {
            final Object source = event.getSource();
            final Collection items = Models.copyAttrs(this.attrCopier, source, Models.filter(this.filter, event.getReplacement()));
            ((AsyncDescriptor)source).removeDescriptorChangeListener(this);
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    int listIndex = ListListModel.this.list.indexOf(source);
                    int includedIndex = ListListModel.this.included.indexOf(source);
                    if (listIndex >= 0) {
                        switch (items.size()) {
                            case 0: {
                                ListListModel.this.list.remove(listIndex);
                                if (includedIndex < 0) break;
                                if (ListListModel.this.included != ListListModel.this.list) {
                                    ListListModel.this.included.remove(includedIndex);
                                }
                                ListListModel.this.fireIntervalRemoved(ListListModel.this, includedIndex, includedIndex);
                                break;
                            }
                            case 1: {
                                Object item = Models.head(items);
                                ListListModel.this.list.set(listIndex, item);
                                if (includedIndex < 0) break;
                                if (ListListModel.this.included != ListListModel.this.list) {
                                    ListListModel.this.included.set(includedIndex, item);
                                }
                                ListListModel.this.fireContentsChanged(ListListModel.this, includedIndex, includedIndex);
                                break;
                            }
                            default: {
                                Object head = Models.head(items);
                                Collection tail = Models.tail(items);
                                ListListModel.this.list.set(listIndex, head);
                                ListListModel.this.list.addAll(listIndex + 1, tail);
                                if (includedIndex < 0) break;
                                if (ListListModel.this.included != ListListModel.this.list) {
                                    ListListModel.this.included.set(includedIndex, head);
                                    ListListModel.this.included.addAll(includedIndex + 1, tail);
                                }
                                ListListModel.this.fireContentsChanged(ListListModel.this, includedIndex, includedIndex);
                                ListListModel.this.fireIntervalAdded(ListListModel.this, includedIndex + 1, includedIndex + tail.size());
                            }
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                r.run();
            } else {
                SwingUtilities.invokeLater(r);
            }
        }

        private void filterData() {
            if (this.filter != null) {
                Models.invokeInEDT(new Callable<Void>(){

                    @Override
                    public Void call() {
                        assert (SwingUtilities.isEventDispatchThread());
                        int oldSize = ListListModel.this.included.size();
                        ArrayList newIncluded = new ArrayList();
                        for (Object item : ListListModel.this.list) {
                            if (!ListListModel.this.filter.accept(item)) continue;
                            newIncluded.add(item);
                        }
                        ListListModel.this.included = newIncluded;
                        int newSize = ListListModel.this.included.size();
                        ListListModel.this.fireContentsChanged(this, 0, Math.max(0, Math.min(oldSize - 1, newSize - 1)));
                        if (oldSize < newSize) {
                            ListListModel.this.fireIntervalAdded(this, oldSize, newSize - 1);
                        } else if (oldSize > newSize) {
                            ListListModel.this.fireIntervalRemoved(this, newSize, oldSize - 1);
                        }
                        return null;
                    }
                });
            }
        }
    }

    public static interface Filter<T> {
        public boolean accept(@NonNull T var1);

        public void addChangeListener(@NonNull ChangeListener var1);

        public void remmoveChangeListener(@NonNull ChangeListener var1);
    }

    public static interface MutableListModel<T>
    extends ListModel<T> {
        public void add(@NonNull Collection<? extends T> var1);

        public void remove(@NonNull Collection<? extends T> var1);
    }
}

