/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.convertor;

import java.util.Collections;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.netbeans.modules.project.ui.convertor.ProjectConvertorAcceptor;
import org.netbeans.spi.project.ui.ProjectConvertor;
import org.openide.filesystems.annotations.LayerBuilder;
import org.openide.filesystems.annotations.LayerGeneratingProcessor;
import org.openide.filesystems.annotations.LayerGenerationException;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ProjectConvertorProcessor
extends LayerGeneratingProcessor {
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(ProjectConvertor.Registration.class.getCanonicalName());
    }

    protected boolean handleProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) throws LayerGenerationException {
        for (Element element : roundEnv.getElementsAnnotatedWith(ProjectConvertor.Registration.class)) {
            if (!element.getKind().isClass()) {
                throw new LayerGenerationException("Annotated element is not a class", element);
            }
            ProjectConvertor.Registration reg = element.getAnnotation(ProjectConvertor.Registration.class);
            Elements elements = this.processingEnv.getElementUtils();
            Types types = this.processingEnv.getTypeUtils();
            TypeElement projectConvertor = elements.getTypeElement(ProjectConvertor.class.getName());
            if (types.isSubtype(((TypeElement)element).asType(), projectConvertor.asType())) {
                LayerBuilder.File f = this.layer(new Element[]{element}).instanceFile("Services/ProjectConvertors", null, null);
                f.stringvalue("instanceOf", ProjectConvertorAcceptor.class.getName());
                f.stringvalue("instanceClass", ProjectConvertorAcceptor.class.getName());
                f.methodvalue("instanceCreate", ProjectConvertor.Result.class.getName(), "create");
                int position = reg.position();
                if (position >= 0) {
                    f.intvalue("position", position);
                }
                f.instanceAttribute("delegate", ProjectConvertor.class);
                String pattern = reg.requiredPattern();
                if (pattern == null || pattern.isEmpty()) {
                    throw new LayerGenerationException(String.format("The %s has to be non empty string.", "requiredPattern"), element);
                }
                try {
                    Pattern.compile(pattern);
                }
                catch (PatternSyntaxException ex) {
                    throw new LayerGenerationException(String.format("The %s is not valid regular expression: %s.", "requiredPattern", ex.getMessage()), element);
                }
                f.stringvalue("requiredPattern", pattern);
                f.write();
                continue;
            }
            throw new LayerGenerationException("Annoated element is not a subclass of ProjectConvertor.", element);
        }
        return true;
    }
}

