/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.dataEntry.ITextEditor;
import com.harrand.coreclasses.db.SqlResult;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.text.TextChangedMgr;
import com.harrand.coregui.Icons;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IProcessObserver;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.FocusRestorer;
import com.harrand.dbwrench.db.comm.ISqlResultObserver;
import com.harrand.dbwrench.db.comm.SqlSender;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchgui.sub.editor.DbwEditor;
import com.harrand.dbwrenchgui.sub.editor.ICommandExecutor;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.server.conn.ConnChecker;
import com.harrand.nb8.topComponent.tools.Bundle;
import com.harrand.nb8.topComponent.tools.QueryResultsTopComponent;
import com.harrand.util.FileHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="SqlCommunicatorTopComponent", iconBase="com/harrand/nb8/topComponent/tools/SqlCommEc16.gif", persistenceType=0)
public final class SqlCommunicatorTopComponent
extends TopComponent
implements ISqlResultObserver,
IObserver,
ICommandExecutor,
ITextEditor {
    public static final String UNTITLED = "(untitled)";
    private final JButton btnSaveFile_ = new JButton("Save File");
    private final JButton btnExec_ = new JButton("Execute SQL");
    private final JLabel lblStatus_ = new JLabel("");
    private DbwEditor editor;
    private final TextChangedMgr textChangedMgr_ = new TextChangedMgr();
    private final SqlSender sqlSender_ = SqlSender.getInstance();
    private final IFileUseMgr fileUseMgr_ = App.getFileUseMgr();
    private File file_ = null;
    private FocusRestorer focusRestorer_;
    private String title;

    public SqlCommunicatorTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_SqlCommunicatorTopComponent());
        this.setToolTipText(Bundle.HINT_SqlCommunicatorTopComponent());
        this.initPanel();
        this.layoutPanel();
        this.setCosmetics();
        this.addListeners();
        this.attachSqlProcessObservers();
        this.refreshFileStrs();
        this.buildFocusRestorer();
        this.setText("");
    }

    public final void setText(String text) {
        this.editor.setText(text);
        this.textChangedMgr_.setLastText(text);
    }

    public void setFile(File file) {
        this.file_ = file;
        this.setText(FileHelper.readFileToString((File)this.file_));
        this.refreshFileStrs();
    }

    protected void componentActivated() {
    }

    private void addListeners() {
        this.btnExec_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlCommunicatorTopComponent.this.execSql();
            }
        });
        this.btnSaveFile_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SqlCommunicatorTopComponent.this.save();
            }
        });
    }

    private void attachSqlProcessObservers() {
        QueryResultsTopComponent resultsTC = this.getResultsTC();
        this.sqlSender_.addSqlProcessObserver((IProcessObserver)resultsTC);
    }

    private void clearResults() {
        QueryResultsTopComponent resultsTC = this.getResultsTC();
        resultsTC.clear();
    }

    private void refresh() {
        this.btnExec_.setEnabled(this.sqlSender_.isFinished());
    }

    private void refreshFileStrs() {
        this.refreshTitle();
        this.refreshToolTip();
    }

    private void refreshTitle() {
        String string = this.title = this.isFileSet() ? this.file_.getName() : UNTITLED;
        if (this.textChangedMgr_.getHasChanged(this.editor.getText())) {
            this.title = this.title + "*";
        }
        this.setDisplayName(this.title);
    }

    private void refreshToolTip() {
        String tip = this.isFileSet() ? this.file_.getPath() : "SQL Editor & Communicator";
        this.setToolTipText(tip);
    }

    private void buildFocusRestorer() {
        ArrayList<DbwEditor> comps = new ArrayList<DbwEditor>();
        comps.add(this.editor);
        this.focusRestorer_ = new FocusRestorer(comps);
    }

    private void showResultsWindow() {
        QueryResultsTopComponent resultsTC = this.getResultsTC();
        if (!resultsTC.isOpened()) {
            resultsTC.open();
        }
        resultsTC.requestActive();
        resultsTC.requestAttention(true);
    }

    public String getText() {
        return this.editor.getText();
    }

    public String getFilePath() {
        if (this.isFileSet()) {
            return this.file_.getPath();
        }
        return null;
    }

    public void saveFile() {
        this.save();
    }

    private void save() {
        if (this.checkFileSet()) {
            FileHelper.saveStringToFile((String)this.editor.getText(), (File)this.file_);
            this.textChangedMgr_.setLastText(this.editor.getText());
            this.refreshFileStrs();
            this.updateFileUseMgr();
            this.focusRestorer_.restoreFocus();
        }
    }

    private boolean checkFileSet() {
        boolean isSet = false;
        if (this.isFileSet()) {
            isSet = true;
        } else {
            File promptFile = GuiMessageHelper.promptForSaveFile((File)this.getDefaultPromptFile());
            if (promptFile != null) {
                isSet = true;
                this.file_ = promptFile;
            }
        }
        return isSet;
    }

    private File getDefaultPromptFile() {
        File mgrFile = this.fileUseMgr_ != null ? this.fileUseMgr_.getDefaultFile("SqlScript", null) : new File("");
        File pathFile = this.file_ != null ? this.file_ : mgrFile;
        return pathFile;
    }

    private void updateFileUseMgr() {
        if (this.fileUseMgr_ != null) {
            this.fileUseMgr_.addRecentFile("SqlScript", this.file_, true);
        }
    }

    private QueryResultsTopComponent getResultsTC() {
        QueryResultsTopComponent tc = (QueryResultsTopComponent)NbUtil.openActivateTc((String)"QueryResultsTopComponent");
        return tc;
    }

    private void execSql() {
        this.clearResults();
        this.showResultsWindow();
        JdbcConfig currentCfg = ConnMgr.getInstance().getCurrentCfg();
        if (ConnChecker.isConfigValid((JdbcConfig)currentCfg)) {
            String sqlText = this.getSendText();
            this.sqlSender_.sendSql(this.btnExec_, this.lblStatus_, sqlText);
        }
    }

    private String getSendText() {
        String selectedText = this.editor.getSelectedText();
        String sendText = selectedText == null || selectedText.length() <= 0 ? this.editor.getText() : selectedText;
        return sendText;
    }

    private void initPanel() {
        this.initEditor();
    }

    private void initEditor() {
        this.editor = new DbwEditor();
        this.editor.setCommandExecutor((ICommandExecutor)this);
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.getHeaderPanel(), "North");
        this.add((Component)this.editor, "Center");
        this.add(this.getSouthPanel(), "South");
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("SQL Editor & Communicator", "Send SQL statements to the server");
        return header;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.add(new JSeparator());
        panel.add(this.getBtnPanel());
        return panel;
    }

    private JPanel getBtnPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 0));
        panel.add(this.lblStatus_);
        panel.add(Box.createGlue());
        panel.add(this.btnExec_);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.btnSaveFile_);
        Border border = BorderFactory.createEmptyBorder(5, 10, 5, 10);
        panel.setBorder(border);
        return panel;
    }

    private void setCosmetics() {
        this.refreshTitle();
        this.refreshToolTip();
        this.setIcon(Icons.SQL_COMM.getImage());
        this.btnSaveFile_.setMnemonic(83);
        this.btnExec_.setMnemonic(88);
        this.btnExec_.setToolTipText("Ctrl + Enter");
        if (ButtonUtil.getUseButtonIcons()) {
            this.btnSaveFile_.setIcon(Icons.SAVE_AS);
            this.btnExec_.setIcon(Icons.EXECUTE);
        }
    }

    private boolean isFileSet() {
        return this.file_ != null;
    }

    public int getPersistenceType() {
        return 2;
    }

    protected String preferredID() {
        return "SqlEditor";
    }

    public void updateResult(SqlResult result, int resultIdx) {
        this.refresh();
    }

    public void updateGeneral() {
        this.refresh();
    }

    public void setCmdCount(int cmdCount) {
    }

    public void update(UpdateChain chain) {
        this.refreshTitle();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public void executeCommand() {
        this.execSql();
    }
}

