/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.system.OsUtil;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.text.LogPanel;
import com.harrand.dbwrench.diagram.bldr.DiagramBldrWorker;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.DataTypeSvr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrenchgui.db.worker.meta.RevEngWorker;
import com.harrand.dbwrenchnb.diagram.NewDiagramMonitor;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import com.harrand.dbwrenchnb.lifecycle.db.DbSaveChecker;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.server.conn.ConnChecker;
import com.harrand.dbwrenchnb.server.display.FadingStatusPanel;
import com.harrand.nb8.topComponent.tools.Bundle;
import com.harrand.sketch.core.Diagram;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="ReverseEngineerTopComponent", iconBase="com/harrand/nb8/topComponent/tools/RevEngEc16.gif", persistenceType=0)
public final class ReverseEngineerTopComponent
extends TopComponent
implements IObserver,
IThreadObserver {
    private LogPanel msgPanel_ = new LogPanel("Message Log", false);
    private final LogPanel errPanel_ = new LogPanel("Error Log", false);
    private FadingStatusPanel statusDisplayer = new FadingStatusPanel(95);
    private JButton btnRevEng_ = new JButton("Reverse Engineer");
    private JLabel lblConn_ = new JLabel("Connection:");
    private JTextField txtConn_ = new JTextField("<no connection selected>");
    private DbUser user_ = App.getUser();
    private CentralLookup centralLookup_ = CentralLookup.getDefault();
    private ConnMgr connMgr_ = ConnMgr.getInstance();
    private DataTypeSvr dataTypeSvr_;
    private SetDb setDb_ = SetDb.getInstance();
    private IMetaDataCtrl metaDataCtrl_;
    private boolean autoloadDb_ = false;
    private static final String NO_CONN_SELECTED = "<no connection selected>";

    public ReverseEngineerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_ReverseEngineerTopComponent());
        this.setToolTipText(Bundle.HINT_ReverseEngineerTopComponent());
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
        this.connMgr_.addObserver((IObserver)this);
        this.centralLookup_.addObserver((IObserver)this);
        this.dataTypeSvr_ = new DataTypeSvr(this.user_.getOptionMgr("data.type.opt.mgr"));
        this.updateConfigInfo();
        this.setBackground(Color.RED);
    }

    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        g2d.setPaint(Color.WHITE);
        g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
    }

    public void showDiagrams(Database db) {
        if (!db.getDiagrams().isEmpty()) {
            Diagram firstDiagram = (Diagram)db.getDiagramsGen().get(0);
            NewDiagramMonitor newDiagramMonitor = db.getNewDiagramMonitor();
            newDiagramMonitor.setEnabled(true);
            newDiagramMonitor.update(new UpdateChain((Object)firstDiagram));
        }
    }

    private void addListeners() {
        this.btnRevEng_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReverseEngineerTopComponent.this.start();
            }
        });
    }

    private void layoutPanel() {
        this.setLayout(new BorderLayout());
        this.add(this.getHeaderPanel(), "North");
        this.add(this.getCenterPanel(), "Center");
    }

    private JPanel getCenterPanel() {
        this.errPanel_.setMinimumSize(new Dimension(400, 90));
        this.errPanel_.setPreferredSize(new Dimension(400, 90));
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.add((Component)this.getNorthPanel(), "North");
        panel.add((Component)this.msgPanel_, "Center");
        panel.add((Component)this.errPanel_, "South");
        GuiHelper.addReducedBodyPanelBorder((JPanel)panel);
        return panel;
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Reverse Engineer", "Reverse engineer an existing database");
        return header;
    }

    private JPanel getNorthPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 0));
        panel.add((Component)this.getConnectionPanel(), "North");
        panel.add((Component)this.statusDisplayer, "South");
        return panel;
    }

    private JPanel getConnectionPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)0, (int)row, (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        gbc.anchor = 17;
        panel.add((Component)this.lblConn_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)1, (int)row, (int)1, (int)1, (double)80.0, (double)0.0);
        gbc.fill = 2;
        panel.add((Component)this.txtConn_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)2, (int)row, (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        panel.add((Component)this.btnRevEng_, gbc);
        return panel;
    }

    private Database startRevEng(JdbcConfig config) {
        long start = System.currentTimeMillis();
        Database db = null;
        try {
            this.metaDataCtrl_ = config.getMetaDataCtrl();
            this.metaDataCtrl_.addObserver((IObserver)this);
            RevEngWorker revEngWorker = new RevEngWorker();
            revEngWorker.setDisabledButton(this.btnRevEng_);
            revEngWorker.setStatusDisplayer((IStatusDisplayer)this.statusDisplayer);
            revEngWorker.startRevEng(config, this.metaDataCtrl_, (IThreadObserver)this);
        }
        catch (Exception e) {
            GuiMessageHelper.showGeneralAppErrMsg(null, (String)e.getMessage());
        }
        long finish = System.currentTimeMillis();
        return db;
    }

    private void loadRevEngDb(Database db) {
        if (this.setDb_ != null) {
            this.setDb_.setCheckSaveFlag(false);
            this.setDb_.set(db);
            this.setDb_.setCheckSaveFlag(true);
            this.autoLayoutGlyphs(db);
            this.dataTypeSvr_.autoEnableDbType(db);
        }
    }

    private void autoLayoutGlyphs(Database db) {
        db.remove(Diagram.getClassName(), "diagramA");
        db.getNewDiagramMonitor().setEnabled(false);
        DiagramBldrWorker diagramBldrWorker = new DiagramBldrWorker();
        diagramBldrWorker.setDisabledButton(this.btnRevEng_);
        diagramBldrWorker.setStatusDisplayer((IStatusDisplayer)this.statusDisplayer);
        diagramBldrWorker.createDiagrams(db, (IThreadObserver)this);
    }

    private void setCosmetics() {
        if (!OsUtil.isMacOs()) {
            this.btnRevEng_.setIcon(Icons.START);
        }
        this.txtConn_.setEditable(false);
        this.btnRevEng_.setMnemonic('R');
    }

    private void start() {
        JdbcConfig config = this.getConfig();
        if (!ConnChecker.isConfigSet((JdbcConfig)config)) {
            return;
        }
        if (config != null && config.isGeneric()) {
            String msg = StrHelper.getGenericCfgMsg((String)"reverse engineer");
            GuiMessageHelper.showWarningMsg(null, (String)"Reverse Engineer", (String)msg);
            return;
        }
        this.promptSaveCurrentDb();
        this.clear();
        config = ConnMgr.getInstance().getCurrentCfg();
        this.startRevEng(config);
    }

    private JdbcConfig getConfig() {
        return this.connMgr_.getCurrentCfg();
    }

    private void updateConfigInfo() {
        JdbcConfig config = this.getConfig();
        String connStr = config != null ? config.getDesc() : NO_CONN_SELECTED;
        this.txtConn_.setText(connStr);
        this.clear();
    }

    private void clear() {
        this.msgPanel_.clear();
        this.errPanel_.clear();
    }

    private String getMilestoneDesc() {
        if (this.metaDataCtrl_ != null) {
            return this.metaDataCtrl_.getMilestoneDesc();
        }
        return null;
    }

    private String getStatusDesc() {
        if (this.metaDataCtrl_ != null) {
            return this.metaDataCtrl_.getStatusDesc();
        }
        return " ";
    }

    public void update(UpdateChain chain) {
        if (chain.hasClassName(ConnMgr.class.getName())) {
            this.updateConfigInfo();
        }
        if (chain.hasInteface(IMetaDataCtrl.class.getName())) {
            this.updateMsgs();
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    public void threadDone(SwingWorker threadWorker) {
        if (threadWorker instanceof RevEngWorker) {
            RevEngWorker worker = (RevEngWorker)threadWorker;
            Database revEngDb = worker.getRevEngDb();
            this.checkLoadDb(revEngDb);
        }
        if (threadWorker instanceof DiagramBldrWorker) {
            DiagramBldrWorker diagramBldrWorker = (DiagramBldrWorker)threadWorker;
            Database db = diagramBldrWorker.getDb();
            this.showDiagrams(db);
        }
    }

    private void checkLoadDb(Database revEngDb) {
        if (revEngDb != null) {
            this.loadRevEngDb(revEngDb);
            NbUtil.openActivateTc((String)"DbExplorerTopComponent");
        }
    }

    private void promptSaveCurrentDb() {
        DbSaveChecker saveChecker = new DbSaveChecker();
        saveChecker.checkSave(true);
    }

    private void updateLog() {
        String milestoneDesc = this.getMilestoneDesc();
        if (milestoneDesc != null) {
            boolean wasError = this.metaDataCtrl_.getWasError();
            if (wasError) {
                this.msgPanel_.logError(milestoneDesc);
                this.errPanel_.logError(milestoneDesc);
            } else {
                this.msgPanel_.logPlain(milestoneDesc);
            }
        }
    }

    private void updateMsgs() {
        this.updateLog();
        this.updateStatusMsg();
    }

    private void updateStatusMsg() {
        this.statusDisplayer.setStatusMsg(this.getStatusDesc());
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return null;
        }
    }
}

