/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.topComponent.tools;

import com.harrand.coreclasses.dataEntry.CompareResult;
import com.harrand.coreclasses.element.DiffItem;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.list.NamedList;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coregui.button.ButtonUtil;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.display.status.IStatusDisplayer;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.coregui.jdesktop.swingworker.IThreadObserver;
import com.harrand.coregui.jdesktop.swingworker.SwingWorker;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.table.ColorableJTable;
import com.harrand.coregui.table.TableModelBasic;
import com.harrand.coregui.text.TextComparePanel;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.metaData.IMetaDataCtrl;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchgui.db.worker.meta.RevEngWorker;
import com.harrand.dbwrenchgui.sync.RevSyncCtrl;
import com.harrand.dbwrenchnb.server.display.FadingStatusPanel;
import com.harrand.dbwrenchnb.server.sync.RevSyncTopComponent;
import com.harrand.nb8.topComponent.tools.Bundle;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Properties;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DbCompareTopComponent", iconBase="com/harrand/nb8/topComponent/tools/RevSyncEc16.gif", persistenceType=0)
public final class DbCompareTopComponent
extends TopComponent
implements IObserver,
IThreadObserver {
    private final RevSyncCtrl syncCtrl_;
    private NamedList diffResults_;
    private IMetaDataCtrl metaDataCtrl_ = null;
    private final CentralLookup centralLookup_ = CentralLookup.getDefault();
    private final ConnMgr connMgr_ = ConnMgr.getInstance();
    private final TableModelBasic model_;
    private final ColorableJTable grid_;
    private final FadingStatusPanel statusDisplayer = new FadingStatusPanel(0);
    private JScrollPane scrPane_;
    private JScrollPane scrDetails_;
    private final JButton btnRefresh = ButtonUtil.getRefreshBtn();
    private final JButton btnSync_ = new JButton("Sync Design");
    private final JTextField txtObjType_ = new JTextField();
    private final JTextField txtObjNm_ = new JTextField();
    private final JTextArea txtDetails_ = new JTextArea();
    private final JButton btnDetail_ = new JButton("Difference Details");
    private final SwingThemeCtrl themeCtrl_;
    private final Object[] colNames_;
    private final Color unEditColor_;
    private final boolean unitTestMode_ = false;
    private int diffNmColIdx = -1;
    private int idfClzColIdx = -1;
    private int syncedColIdx = -1;

    public DbCompareTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_DbCompareTopComponent());
        this.setToolTipText(Bundle.HINT_DbCompareTopComponent());
        this.syncCtrl_ = new RevSyncCtrl(LookupUtil.findDb());
        this.syncCtrl_.addObserver((IObserver)this);
        this.connMgr_.addObserver((IObserver)this);
        this.centralLookup_.addObserver((IObserver)this);
        this.colNames_ = this.syncCtrl_.getColNames();
        this.themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();
        this.model_ = new TableModelBasic(new Object[0][0], this.colNames_);
        this.model_.setEditable(false);
        this.grid_ = new ColorableJTable((TableModel)this.model_);
        this.hideColumns();
        this.unEditColor_ = this.themeCtrl_.getUneditColumnBackground();
        this.setupGui();
        this.setColumnIndexes();
    }

    public static String getTitle() throws MissingResourceException {
        return NbBundle.getMessage(RevSyncTopComponent.class, (String)"CTL_RevSyncTopComponent");
    }

    public String getDisplayName() {
        return this.getName();
    }

    public void refresh() {
        this.clearAll();
        JdbcConfig config = this.getConfig();
        if (config != null && config.isGeneric()) {
            String msg = StrHelper.getGenericCfgMsg((String)"database compare");
            GuiMessageHelper.showWarningMsg(null, (String)"Database Compare", (String)msg);
            return;
        }
        this.startRevEngDb();
    }

    private void clearAll() {
        this.model_.setDataVector(new Object[0][this.colNames_.length], this.colNames_);
        this.hideColumns();
        this.txtObjType_.setText("");
        this.txtObjNm_.setText("");
        this.txtDetails_.setText("");
    }

    private void refreshDiffResults(Database revEngDb) {
        this.syncCtrl_.setDesignDb(LookupUtil.findDb());
        this.syncCtrl_.setSvrDb(revEngDb);
        if (this.syncCtrl_.getSvrDb() != null) {
            this.syncCtrl_.setConfig(this.getConfig());
            this.syncCtrl_.refresh();
            this.diffResults_ = this.syncCtrl_.getDiffResults();
        }
    }

    private void refreshTable() {
        Object[][] data = this.syncCtrl_.getDataMatrix();
        this.model_.setDataVector(data, this.colNames_);
        this.hideColumns();
        GuiHelper.optimizeTableColumnWidths((JTable)this.grid_, (int)250);
        this.updateSyncedColor();
    }

    private void hideColumns() {
        TableColumnModel tcm = this.grid_.getColumnModel();
        TableColumn clzCol = this.grid_.getColumn((Object)"Clz");
        tcm.removeColumn(clzCol);
    }

    private void setStatusMsg(String msg) {
        this.statusDisplayer.setStatusMsg(msg);
    }

    private void setFocusOnGrid() {
        this.grid_.requestFocus();
        if (this.grid_.getRowCount() > 0) {
            this.grid_.setRowSelectionInterval(0, 0);
        }
    }

    private void syncDesign() {
        int[] selectRows = this.grid_.getSelectedRows();
        boolean selectOk = this.getSelectionOk();
        if (!selectOk) {
            return;
        }
        ArrayList<String> selectedDiffNms = new ArrayList<String>();
        for (int i = 0; i < selectRows.length; ++i) {
            int row = selectRows[i];
            String idfClz = this.model_.getValueAt(row, this.idfClzColIdx).toString();
            String objNm = this.model_.getValueAt(row, this.diffNmColIdx).toString();
            String fullNm = idfClz + "." + objNm;
            selectedDiffNms.add(fullNm);
        }
        ITestResult validRslt = this.syncCtrl_.getIsSyncValid(selectedDiffNms);
        if (!validRslt.getPassed()) {
            GuiMessageHelper.showInputErrMsg(null, (ITestResult)validRslt);
            return;
        }
        this.syncDesignDisp(selectedDiffNms);
    }

    private void syncDesignDisp(List selectedDiffNms) {
        ArrayList dupSelectedDiffNms = new ArrayList(selectedDiffNms);
        this.setStatusMsg(StrHelper.SYNCING_STR);
        this.syncCtrl_.syncDb(dupSelectedDiffNms);
        this.clearAll();
        this.refreshTable();
        this.setStatusMsg(StrHelper.READY_STR);
    }

    private boolean getSelectionOk() {
        int[] selectRows = this.grid_.getSelectedRows();
        if (selectRows.length == 0) {
            GuiMessageHelper.showOptionPaneMsg(null, (String)StrHelper.INVALID_SEL_STR, (String)"At least one row must be selected.", (int)2);
            return false;
        }
        boolean validRowSelected = false;
        for (int i = 0; i < selectRows.length; ++i) {
            int row = selectRows[i];
            String cellStr = this.model_.getValueAt(row, this.syncedColIdx).toString();
            if (!cellStr.equalsIgnoreCase(StrHelper.NO_STR)) continue;
            validRowSelected = true;
        }
        if (!validRowSelected) {
            GuiMessageHelper.showOptionPaneMsg(null, (String)StrHelper.INVALID_SEL_STR, (String)"At least one non synchronized row must be selected.", (int)2);
            return false;
        }
        return true;
    }

    private void updateSyncedColor() {
        int rowCount = this.grid_.getRowCount();
        int colCount = this.grid_.getColumnModel().getColumnCount();
        Color[][] colors = new Color[rowCount][colCount];
        for (int row = 0; row < rowCount; ++row) {
            String cellStr = this.model_.getValueAt(row, this.syncedColIdx).toString();
            Color cellColor = cellStr.equalsIgnoreCase(StrHelper.YES_STR) ? this.unEditColor_ : Color.WHITE;
            for (int col = 0; col < colCount; ++col) {
                colors[row][col] = cellColor;
            }
        }
        this.grid_.setColorMatrix(colors);
    }

    private JdbcConfig getConfig() {
        return this.connMgr_.getCurrentCfg();
    }

    private void startRevEngDb() {
        JdbcConfig config = this.getConfig();
        this.metaDataCtrl_ = config.getMetaDataCtrl();
        this.metaDataCtrl_.addObserver((IObserver)this);
        RevEngWorker revEngWorker = new RevEngWorker();
        revEngWorker.setForRevSync(false);
        revEngWorker.setDisabledButton(this.btnRefresh);
        revEngWorker.setStatusDisplayer((IStatusDisplayer)this.statusDisplayer);
        revEngWorker.startRevEng(config, this.metaDataCtrl_, (IThreadObserver)this);
    }

    private void setColumnIndexes() {
        this.idfClzColIdx = GuiHelper.getTableModelColIdx((DefaultTableModel)this.model_, (String)"Clz");
        this.diffNmColIdx = GuiHelper.getTableModelColIdx((DefaultTableModel)this.model_, (String)"Object Name");
        this.syncedColIdx = GuiHelper.getTableModelColIdx((DefaultTableModel)this.model_, (String)"Synced");
    }

    private void setupGui() {
        this.layoutComponents();
        this.setCosmetics();
        this.setNames();
        this.addListeners();
    }

    private void layoutComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.getHeaderPanel(), "North");
        this.add(this.getSyncPanel(), "Center");
    }

    private JPanel getSyncPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.getGridPanel(), "Center");
        return panel;
    }

    private JPanel getGridPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        this.scrPane_ = new JScrollPane((Component)this.grid_);
        panel.add((Component)new JLabel("Database Differences"), "North");
        panel.add((Component)this.scrPane_, "Center");
        panel.add((Component)this.getSouthPanel(), "South");
        GuiHelper.addReducedBodyPanelBorder((JPanel)panel);
        return panel;
    }

    private JPanel getSouthPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 4));
        panel.add((Component)this.getButtonPanel(), "North");
        panel.add((Component)this.getDetailPanel(), "South");
        return panel;
    }

    private JPanel getDetailPanel() {
        JPanel panel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        panel.setLayout(gbl);
        int row = 0;
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)0, (int)row, (int)1, (int)1, (double)10.0, (double)0.0);
        gbc.fill = 0;
        gbc.anchor = 18;
        panel.add((Component)this.btnDetail_, gbc);
        GuiHelper.buildGridBagConstraints((GridBagConstraints)gbc, (int)1, (int)row++, (int)1, (int)1, (double)90.0, (double)30.0);
        gbc.fill = 1;
        gbc.anchor = 18;
        this.scrDetails_ = new JScrollPane(this.txtDetails_);
        panel.add((Component)this.scrDetails_, gbc);
        Dimension minBounds = new Dimension(100, 50);
        panel.setMinimumSize(minBounds);
        panel.setPreferredSize(minBounds);
        return panel;
    }

    private JPanel getButtonPanel() {
        Dimension gap = new Dimension(5, 0);
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add((Component)this.statusDisplayer);
        panel.add(Box.createHorizontalGlue());
        panel.add(this.btnRefresh);
        panel.add(Box.createRigidArea(gap));
        panel.add(this.btnSync_);
        this.themeCtrl_.process(panel);
        return panel;
    }

    private JPanel getHeaderPanel() {
        XpHeaderPanel header = new XpHeaderPanel(this.getName(), this.getToolTipText());
        return header;
    }

    private void setCosmetics() {
        this.sizeButtons();
        this.btnSync_.setToolTipText("Synchronize Selected Items");
        this.txtObjType_.setBackground(this.unEditColor_);
        this.txtObjType_.setEditable(false);
        this.txtObjNm_.setBackground(this.unEditColor_);
        this.txtObjNm_.setEditable(false);
        this.txtDetails_.setBackground(this.unEditColor_);
        this.txtDetails_.setEditable(false);
        Font textFont = this.txtObjNm_.getFont();
        this.txtDetails_.setFont(textFont);
        this.themeCtrl_.process((JTable)this.grid_);
        this.themeCtrl_.process(this.scrPane_);
        this.btnSync_.setMnemonic('S');
        this.btnDetail_.setMnemonic('D');
    }

    private void sizeButtons() {
        Dimension commonSize = this.btnSync_.getMinimumSize();
        this.btnRefresh.setMaximumSize(commonSize);
    }

    private void setNames() {
        this.grid_.setName("grid");
        this.txtObjType_.setName("txtObjType");
        this.txtObjNm_.setName("txtObjNm");
        this.txtDetails_.setName("txtDetails");
        this.btnRefresh.setName("btnRefresh");
        this.btnSync_.setName("btnSync");
    }

    private void addListeners() {
        ListSelectionListener lisSelect = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int rowIndex = DbCompareTopComponent.this.grid_.getSelectionModel().getAnchorSelectionIndex();
                if (rowIndex >= 0) {
                    CompareResult result = (CompareResult)DbCompareTopComponent.this.diffResults_.get(rowIndex);
                    DbCompareTopComponent.this.txtObjType_.setText(result.getDisplayClzNm());
                    DbCompareTopComponent.this.txtObjNm_.setText(result.getObjectName());
                    DbCompareTopComponent.this.txtDetails_.setText(result.getDetail());
                    DbCompareTopComponent.this.txtDetails_.setCaretPosition(0);
                }
            }
        };
        this.grid_.getSelectionModel().addListSelectionListener(lisSelect);
        this.btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbCompareTopComponent.this.refresh();
            }
        });
        this.btnSync_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbCompareTopComponent.this.syncDesign();
            }
        });
        this.btnDetail_.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DbCompareTopComponent.this.showTextCompare();
            }
        });
        this.addTableMouseListeners();
        this.addGridKeyListeners();
    }

    private void addTableMouseListeners() {
        this.grid_.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DbCompareTopComponent.this.showTextCompare();
                }
            }
        });
    }

    private void addGridKeyListeners() {
        this.grid_.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DbCompareTopComponent.this.showTextCompare();
                    e.consume();
                }
            }
        });
    }

    private void checkDbChanged() {
        Database currentDb = LookupUtil.findDb();
        if (currentDb != null) {
            boolean changed;
            Database lastDb = this.syncCtrl_.getDesignDb();
            boolean bl = changed = !currentDb.equals((Object)lastDb);
            if (changed) {
                this.clearAll();
            }
        }
    }

    public void update(UpdateChain chain) {
        if (chain.hasInteface(IMetaDataCtrl.class.getName())) {
            this.updateRevEngStatus(this.metaDataCtrl_.getMilestoneDesc());
        }
        if (chain.hasClassName(ConnMgr.class.getName())) {
            this.clearAll();
        }
        if (chain.hasClassName(CentralLookup.class.getName()) || chain.hasClassName(Database.class.getName())) {
            this.checkDbChanged();
        }
        if (chain.hasClassName("RevSyncCtrl")) {
            this.setStatusMsg(this.syncCtrl_.getSyncedCountMsg());
        }
    }

    private void updateRevEngStatus(String mileStone) {
        String prefix = "Analyzing Server Database: Analyzing ";
        String suffix = "";
        String msg = "";
        if (mileStone == null) {
            return;
        }
        if (mileStone.contains("schema")) {
            suffix = "schemas...";
        }
        if (mileStone.contains("table")) {
            suffix = "tables...";
        }
        if (mileStone.contains("foreign key")) {
            suffix = "foreign keys...";
        }
        if (mileStone.contains("Proc")) {
            suffix = "procedures...";
        }
        if (mileStone.contains("view")) {
            suffix = "views...";
        }
        if (suffix.length() > 0) {
            this.setStatusMsg(prefix + suffix);
        }
    }

    private void showTextCompare() {
        int rowIndex = this.grid_.getSelectionModel().getMinSelectionIndex();
        if (rowIndex >= 0) {
            CompareResult result = (CompareResult)this.diffResults_.get(rowIndex);
            StringBuilder sbSvr = new StringBuilder();
            StringBuilder sbDesign = new StringBuilder();
            List diffItems = result.getDiffItems();
            for (DiffItem diffItem : diffItems) {
                String valueA = diffItem.getValueA();
                String valueB = diffItem.getValueB();
                boolean doLineFeed = valueA.indexOf("\n") > 0 || valueB.indexOf("\n") > 0;
                String lineFeedStr = doLineFeed ? ":\n" : ": ";
                String title = diffItem.getTitle() + lineFeedStr;
                sbSvr.append(title).append(valueA).append("\n");
                sbDesign.append(title + valueB + "\n");
            }
            TextComparePanel panel = new TextComparePanel(sbSvr.toString(), sbDesign.toString(), "Server Value", "Design Value");
            String title = "Server & Design Values for: " + result.getObjectName() + " (" + result.getDisplayClzNm() + ")";
            panel.setTitle(title);
            CloseDialog dlg = new CloseDialog(null, true, (JPanel)panel);
            dlg.setVisible(true);
        } else {
            GuiMessageHelper.showInputErrMsg(null, (String)"Invalid Selection", (String)"A row must be selected from the above table.");
        }
    }

    public void threadDone(SwingWorker threadWorker) {
        RevEngWorker worker = (RevEngWorker)threadWorker;
        Database revEngDb = worker.getRevEngDb();
        this.refreshDiffResults(revEngDb);
        this.refreshTable();
        this.setFocusOnGrid();
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }
}

