/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.lifecycle;

import com.harrand.coreclasses.auth.lic.LicensingCtrl;
import com.harrand.coreclasses.eula.IEulaMgr;
import com.harrand.coreclasses.file.IFileUseMgr;
import com.harrand.coreclasses.interfaces.ITestResult;
import com.harrand.coreclasses.security.ICodeStore;
import com.harrand.coregui.command.CommandChain;
import com.harrand.coregui.command.CommandChainMgr;
import com.harrand.coregui.dialog.CloseDialog;
import com.harrand.coregui.dialog.ParentFrameSvr;
import com.harrand.coregui.panel.EulaPanel;
import com.harrand.dbwrench.command.provider.IOpenSqlFile;
import com.harrand.dbwrench.command.provider.Nb8ActionBuilderProvider;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.dbwrench.sql.show.IShowTableSqlActionBuilder;
import com.harrand.dbwrenchgui.panel.lic.LicensingUI_Ctrl;
import com.harrand.dbwrenchnb.lifecycle.EditorFontInitializer;
import com.harrand.dbwrenchnb.lifecycle.db.DbSaveChecker;
import com.harrand.dbwrenchnb.menu.RecentFilesMenu;
import com.harrand.dbwrenchnb.menu.UndoRedoToolbar;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.nb8.action.file.OpenSqlFileDispatch;
import com.harrand.nb8.action.table.ShowTableSqlActionBuilder;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.windows.WindowManager;

public class Installer
extends ModuleInstall {
    private DbUser user_;
    private static final String DEMARC = "**** ";
    private static final String MAIN_TITLE = "DbWrench Database Design and Synchronization";

    public void restored() {
        this.loadDbUser();
        this.setCommandChain();
        this.initUI();
        this.initShowSqlActions();
    }

    public boolean closing() {
        boolean superValue = super.closing();
        boolean useMultithreadedSave = false;
        new DbSaveChecker().checkSave(false);
        Installer.initEditorFont();
        return superValue;
    }

    private static void initEditorFont() {
        EditorFontInitializer fontInitializer = new EditorFontInitializer();
        fontInitializer.checkEditorFontSet();
    }

    private void exitApp() {
        LifecycleManager.getDefault().exit();
    }

    private void loadDbUser() {
        App.startup(null, (int)0);
        this.user_ = App.getUser();
        this.setRecentFileMenuMgr();
    }

    private void initUI() {
        WindowManager.getDefault().invokeWhenUIReady(new Runnable(){

            @Override
            public void run() {
                WindowManager.getDefault().getMainWindow().setTitle(Installer.MAIN_TITLE);
                UndoRedoToolbar.getInstance().setCommandChain(CommandChainMgr.getInstance().getCommandChain());
                Installer.this.validateCode();
                Installer.this.checkEula();
                Installer.this.initLogs();
                ParentFrameSvr.instance().setParentFrame(NbUtil.getMainWindow());
            }
        });
    }

    private void setCommandChain() {
        CommandChainMgr.getInstance().setCommandChain(new CommandChain("ApplicationCmdChain"));
        App.setCommandChain((CommandChain)CommandChainMgr.getInstance().getCommandChain());
    }

    private void setRecentFileMenuMgr() {
        IFileUseMgr recentFileMenuMgr = this.getFileUserMgr();
        RecentFilesMenu.getInstance().setFileUseMgr(recentFileMenuMgr);
    }

    private void initLogs() {
    }

    private IFileUseMgr getFileUserMgr() {
        return App.getFileUseMgr();
    }

    private void validateCode() {
        LicensingCtrl.getInstance().setCodeStore((ICodeStore)this.user_);
        ITestResult result = LicensingUI_Ctrl.getInstance().hasOperableLicense();
        if (!result.getPassed()) {
            this.exitApp();
        }
        if (LicensingUI_Ctrl.getInstance().getShowLicensePanel()) {
            NbUtil.openActivateTc((String)"LicenseInformationTopComponent");
        }
    }

    private void checkEula() {
        if (!this.user_.getEulaAccepted()) {
            EulaPanel eulaPanel = new EulaPanel(App.getEulaTextSvr(), (IEulaMgr)this.user_);
            CloseDialog dlg = new CloseDialog(null, true, (JPanel)eulaPanel, false);
            eulaPanel.setParentDialog((JDialog)dlg);
            dlg.setResizable(false);
            dlg.setVisible(true);
            if (!eulaPanel.getEulaAccepted()) {
                this.exitApp();
            }
        }
    }

    private void initShowSqlActions() {
        Nb8ActionBuilderProvider actionBuilderProvider = Nb8ActionBuilderProvider.getInstance();
        actionBuilderProvider.setShowTableSqlActionBuilder((IShowTableSqlActionBuilder)new ShowTableSqlActionBuilder());
        actionBuilderProvider.setOpenSqlFile((IOpenSqlFile)new OpenSqlFileDispatch());
    }
}

