/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.lifecycle;

import com.harrand.coreclasses.dataEntry.IChildComponent;
import com.harrand.coreclasses.dataEntry.ISized;
import com.harrand.coreclasses.help.StrHelper;
import com.harrand.coreclasses.interfaces.ITitled;
import com.harrand.coregui.Icons;
import com.harrand.coregui.display.SwingThemeCtrl;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.panel.XpHeaderPanel;
import com.harrand.coregui.security.CodeBtnPanel;
import com.harrand.util.ResMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public final class CodeWarningPanel
extends JPanel
implements ITitled,
ISized,
IChildComponent {
    private JTextField txtWarnMsg_ = new JTextField("");
    private String title_ = "Reminder";
    private String wildCardMsg_ = ResMgr.getRes((String)"license.trial.will.expire.msg");
    private boolean showLicensePanelAfter_ = false;
    private CodeBtnPanel codeBtnPanel_;
    private RootPaneContainer parentContainer_;
    private SwingThemeCtrl themeCtrl_ = SwingThemeCtrl.getDefaultCtrlInstance();

    @Deprecated
    public CodeWarningPanel(int daysRemaining) {
        this.initBtnPanel();
        this.setupGui();
        this.setWarningMsg(daysRemaining);
    }

    public CodeWarningPanel(String warningMsg) {
        this.initBtnPanel();
        this.setupGui();
        this.txtWarnMsg_.setText(warningMsg);
    }

    private void setWarningMsg(int daysRemaining) {
        String daysRemaingMsg = StrHelper.replaceWildCard((String)this.wildCardMsg_, (String)Integer.toString(daysRemaining));
        this.txtWarnMsg_.setText(daysRemaingMsg);
    }

    public void setParentContainer(RootPaneContainer parentContainer) {
        this.parentContainer_ = parentContainer;
        this.codeBtnPanel_.setParentContainer(parentContainer);
        if (this.parentContainer_ != null) {
            GuiHelper.addCancelStroke((RootPaneContainer)this.parentContainer_);
        }
    }

    public boolean getShowLicensePanelAfter() {
        return this.showLicensePanelAfter_;
    }

    private void setupGui() {
        this.layoutPanel();
        this.addListeners();
        this.setCosmetics();
    }

    private void addListeners() {
        ActionListener lisUpdate = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeWarningPanel.this.showLicensePanelAfter_ = true;
                GuiHelper.closeParent((RootPaneContainer)CodeWarningPanel.this.parentContainer_);
            }
        };
        this.codeBtnPanel_.setUpdateBtnListener(lisUpdate);
    }

    public String getTitle() {
        return this.title_;
    }

    public String getToolTip() {
        return ResMgr.getRes((String)"license.info.title");
    }

    public ImageIcon getIcon() {
        return Icons.SECURITY;
    }

    public Rectangle getPreferredBounds() {
        return new Rectangle(50, 50, 540, 290);
    }

    private void layoutPanel() {
        XpHeaderPanel header = new XpHeaderPanel("Reminder", this.getToolTip());
        this.setLayout(new BorderLayout());
        this.add((Component)header, "North");
        this.add((Component)this.getCenterPanel(), "Center");
        this.add((Component)this.codeBtnPanel_, "South");
    }

    private JPanel getCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.txtWarnMsg_, "Center");
        Border border = BorderFactory.createEmptyBorder(10, 0, 30, 0);
        panel.setBorder(border);
        return panel;
    }

    private void initBtnPanel() {
        this.codeBtnPanel_ = new CodeBtnPanel(false);
    }

    private void setCosmetics() {
        this.txtWarnMsg_.setEditable(false);
        this.txtWarnMsg_.setBackground(this.themeCtrl_.getUneditColumnBackground());
        this.txtWarnMsg_.setHorizontalAlignment(0);
    }
}

