/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.action.tools;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.option.IOptionMgr;
import com.harrand.coreclasses.script.IConnectionConfig;
import com.harrand.coregui.helper.GuiHelper;
import com.harrand.coregui.list.IconListCellRenderer;
import com.harrand.dbwrench.jdbc.ConnMgr;
import com.harrand.dbwrench.jdbc.IJdbcConfigObserver;
import com.harrand.dbwrench.jdbc.JdbcConfig;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrench.security.DbUser;
import com.harrand.util.LogUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class PickConnection
extends CallableSystemAction
implements IObserver,
IJdbcConfigObserver {
    private JComboBox combo_;
    private ActionListener lisCombo_;
    private Database filterDb_;
    private final DbUser dbUser_ = App.getUser();
    private final IOptionMgr conOptMgr_;
    private final IOptionMgr forEngOptMgr_;

    public PickConnection() {
        this.dbUser_.addObserver((IObserver)this);
        CentralLookup.getDefault().addObserver((IObserver)this);
        this.conOptMgr_ = this.dbUser_.getOptionMgr("conn.opt.mgr");
        this.forEngOptMgr_ = this.dbUser_.getOptionMgr("forward.engineer.option.mgr");
        this.buildComboBox();
        this.addListeners();
        this.setLastConn();
        this.dbUser_.setJdbcConfigObserver((IJdbcConfigObserver)this);
    }

    public void actionPerformed(ActionEvent e) {
    }

    public void performAction() {
    }

    public Component getToolbarPresenter() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(10));
        panel.add(new JLabel("Connection:"));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.combo_);
        panel.add(Box.createHorizontalStrut(20));
        return panel;
    }

    public void setFilterDatabase(Database db) {
        this.filterDb_ = db;
        this.loadConnectionConfigs();
    }

    public Database getFilterDatabase() {
        return this.filterDb_;
    }

    private void buildComboBox() {
        this.combo_ = new JComboBox();
        this.combo_.setName("configCombo");
        this.combo_.setRenderer(new IconListCellRenderer());
        this.loadConnectionConfigs();
    }

    private void addListeners() {
        this.lisCombo_ = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PickConnection.this.saveLastConn();
                PickConnection.this.updateConnMgr();
            }
        };
        this.combo_.addActionListener(this.lisCombo_);
    }

    private void setLastConn() {
        int lastConnIdx = this.conOptMgr_.getIntValue("last.conn.idx");
        if (lastConnIdx >= 0) {
            if (lastConnIdx < this.combo_.getItemCount()) {
                this.combo_.setSelectedIndex(lastConnIdx);
            } else {
                LogUtil.logErr((String)("PickConn.lastConnIdx exceeds combo range: " + lastConnIdx));
            }
        } else {
            LogUtil.logErr((String)("PickConn.lastConnIdx.unset: " + lastConnIdx));
        }
    }

    private void saveLastConn() {
        int selectedIndex = this.combo_.getSelectedIndex();
        this.conOptMgr_.setIntValue("last.conn.idx", selectedIndex);
    }

    private void updateConnMgr() {
        ConnMgr mgr = ConnMgr.getInstance();
        mgr.setCurrentCfg(this.getSelectedConn());
    }

    private JdbcConfig getSelectedConn() {
        JdbcConfig selected = (JdbcConfig)this.combo_.getSelectedItem();
        return selected;
    }

    private void loadConnectionConfigs() {
        List configs = this.dbUser_.values(JdbcConfig.clazz());
        if (this.filterDb_ != null) {
            ArrayList<JdbcConfig> keepConfigs = new ArrayList<JdbcConfig>();
            for (JdbcConfig config : configs) {
                String dbName = config.getObjectInstanceName();
                if (dbName.equalsIgnoreCase(this.filterDb_.getName())) {
                    keepConfigs.add(config);
                    continue;
                }
                if (config.getDbmsId() != 2) continue;
                keepConfigs.add(config);
            }
            configs.retainAll(keepConfigs);
        }
        configs.addAll(JdbcConfig.getGenericConfigs());
        GuiHelper.loadComboBox((JComboBox)this.combo_, (Object[])configs.toArray());
        this.updateConnMgr();
    }

    public String getName() {
        return "Pick Server Connection";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    private void checkDbChanged() {
        boolean doFiltering = this.forEngOptMgr_.getBoolValue("forward.engineer.filter.conn");
        if (!doFiltering) {
            this.filterDb_ = null;
            this.loadConnectionConfigs();
        } else {
            Database currentDb = LookupUtil.findDb();
            if (currentDb != null) {
                boolean changed;
                boolean bl = changed = !currentDb.equals((Object)this.filterDb_);
                if (changed) {
                    this.filterDb_ = currentDb;
                    this.loadConnectionConfigs();
                }
            }
        }
    }

    public void update(UpdateChain chain) {
        if (chain.hasInteface(IConnectionConfig.class.getName())) {
            this.loadConnectionConfigs();
        }
        if (chain.hasClassName(CentralLookup.class.getName()) && chain.hasClassName(Database.class.getName())) {
            this.checkDbChanged();
        }
    }

    public void setCurrentConfig(JdbcConfig config) {
        this.loadConnectionConfigs();
        this.combo_.setSelectedItem(config);
    }
}

