/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.action.file;

import com.harrand.coreclasses.dataEntry.OpenEditorVO;
import com.harrand.coreclasses.element.CollectorIdf;
import com.harrand.coreclasses.interfaces.Collector;
import com.harrand.coreclasses.interfaces.Identifiable;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coregui.helper.GuiMessageHelper;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.security.App;
import com.harrand.dbwrenchnb.action.db.SaveUtil;
import com.harrand.dbwrenchnb.lifecycle.SetDb;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.sketch.core.Diagram;
import com.harrand.util.FileHelper;
import com.harrand.util.ResMgr;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JOptionPane;

public final class NewDb
implements ActionListener {
    @Override
    public void actionPerformed(ActionEvent e) {
        this.checkSave();
        String newDatabaseName = JOptionPane.showInputDialog(NbUtil.getMainWindow(), App.getRes((String)"database.new.prompt"), App.getRes((String)"database.new.label"), 3);
        if (newDatabaseName != null) {
            try {
                Database dbNew = new Database(newDatabaseName);
                dbNew.addDefaultDiagram();
                this.setOpenDiagram(dbNew);
                this.SetNewDb(dbNew);
            }
            catch (Exception ex) {
                GuiMessageHelper.showInputErrMsg(null, (String)ResMgr.getRes((String)"err.data.entry.invalid.title"), (String)ex.getMessage());
            }
        }
    }

    public void checkSave() {
        Database db = this.getLookupDb();
        if (db != null && this.getDbDirty()) {
            String msg = FileHelper.getRes((String)"save.changes.msg") + db.getFileName();
            boolean response = GuiMessageHelper.showYesNoMsg(null, (String)FileHelper.getRes((String)"save.changes.title"), (String)msg);
            if (response) {
                this.saveDatabaseDisp();
            }
        }
    }

    private void SetNewDb(Database dbNew) {
        SetDb setDb = SetDb.getInstance();
        setDb.setCheckSaveFlag(false);
        setDb.setDatabase(dbNew);
        setDb.setCheckSaveFlag(true);
    }

    private boolean getDbDirty() {
        return SetDb.getInstance().getDirty();
    }

    private Database getLookupDb() {
        return (Database)CentralLookup.getDefault().lookup(Database.class);
    }

    private void saveDatabaseDisp() {
        SaveUtil.getInstance().saveAll();
    }

    private void setOpenDiagram(Database dbNew) {
        ArrayList<OpenEditorVO> VOs = new ArrayList<OpenEditorVO>();
        Diagram diagram = dbNew.getDiagram("diagramA");
        CollectorIdf collIdf = new CollectorIdf((Collector)dbNew, (Identifiable)diagram);
        OpenEditorVO VO = new OpenEditorVO(collIdf, true);
        VOs.add(VO);
        dbNew.setOpenEditors(VOs);
    }
}

