/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8.action.diagram.zoom;

import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.coreclasses.notification.IObserver;
import com.harrand.coreclasses.notification.UpdateChain;
import com.harrand.coreclasses.zoom.Zoom;
import com.harrand.coregui.Icons;
import com.harrand.dbwrenchnb.action.diagram.support.ZoomCmdDisp;
import com.harrand.sketch.core.Diagram;
import com.harrand.sketch.core.RenderConfig;
import com.harrand.sketch.zoom.IZoomToolbar;
import com.harrand.sketch.zoom.ZoomToolbarServer;
import com.harrand.sketch.zoom.ZoomValidator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openide.util.HelpCtx;
import org.openide.util.actions.CallableSystemAction;

public final class ZoomToolbar
extends CallableSystemAction
implements IObserver,
MouseListener,
IZoomToolbar {
    private static ZoomToolbar instance__ = null;
    private Diagram diagram_ = null;
    private final JTextField txtLevel = new JTextField(3);
    private final JLabel lblPercentSign = new JLabel("%");
    private final JLabel lblClickActionsOn = new JLabel("", ICON_ON, 0);
    private final ZoomValidator zoomValidator = new ZoomValidator();
    private static final ImageIcon ICON_ON = Icons.CLICK_ACTIONS_ON;
    private static final ImageIcon ICON_OFF = Icons.CLICK_ACTIONS_OFF;
    private static final String BLANK_TEXT = "    ";
    private boolean focusListenerAdded;

    public ZoomToolbar() {
        CentralLookup.getDefault().addObserver((IObserver)this);
        instance__ = this;
        this.setCosmetics();
        this.addListeners();
        ZoomToolbarServer.getInstance().setZoomToolbar((IZoomToolbar)this);
    }

    public static ZoomToolbar getInstance() {
        return instance__;
    }

    public Component getToolbarPresenter() {
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 2));
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.txtLevel);
        panel.add(this.lblPercentSign);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.lblClickActionsOn);
        panel.add(Box.createHorizontalStrut(5));
        return panel;
    }

    public void setDiagram(Diagram diagram) {
        this.checkRemoveObserver();
        this.diagram_ = diagram;
        if (this.isDiagramSet()) {
            this.diagram_.addObserver((IObserver)this);
            this.addRcObserver();
        }
        this.refresh();
    }

    private void addRcObserver() {
        this.getRc().addObserver((IObserver)this);
    }

    private void checkRemoveObserver() {
        if (this.isDiagramSet()) {
            this.diagram_.removeObserver((IObserver)this);
        }
    }

    private RenderConfig getRc() {
        return this.diagram_.getRenderConfig();
    }

    private void refreshClickActionBtn() {
        this.lblClickActionsOn.setEnabled(true);
        ImageIcon displayIcon = this.getClickActionOn() ? ICON_ON : ICON_OFF;
        this.lblClickActionsOn.setIcon(displayIcon);
    }

    private boolean getClickActionOn() {
        return this.getRc().getClickActionsOn();
    }

    private void setBlankText() {
        this.txtLevel.setText(BLANK_TEXT);
    }

    private void refresh() {
        if (this.isDiagramSet()) {
            Double asPercent = this.getCurrentZoom().getLevelObject() * 100.0;
            Integer zmInt = (int)asPercent.doubleValue();
            String txt = zmInt.toString();
            this.txtLevel.setText(txt);
            this.refreshClickActionBtn();
            if (!this.focusListenerAdded) {
                this.txtLevel.addFocusListener(new ZoomTextFocusListener());
                this.focusListenerAdded = true;
            }
        } else {
            this.setBlankText();
            this.lblClickActionsOn.setEnabled(false);
        }
    }

    private void toggleClickActions() {
        boolean lastSetting = this.getClickActionOn();
        this.getRc().setClickActionsOn(!lastSetting);
    }

    private boolean isDiagramSet() {
        return this.diagram_ != null;
    }

    public void update(UpdateChain chain) {
        this.refresh();
    }

    public String getName() {
        return "Zoom Toolbar";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
    }

    private void setCosmetics() {
        this.lblClickActionsOn.setToolTipText("Toggle Click Actions (Ctrl+F3)");
        this.txtLevel.setHorizontalAlignment(4);
        Dimension size = new Dimension(24, 24);
        this.lblClickActionsOn.setMinimumSize(size);
        this.lblClickActionsOn.setPreferredSize(size);
    }

    private void addListeners() {
        this.lblClickActionsOn.addMouseListener(this);
        this.txtLevel.addKeyListener(new ZoomTextKeyListener());
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        this.toggleClickActions();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.lblClickActionsOn.setBorder(BorderFactory.createEtchedBorder());
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.lblClickActionsOn.setBorder(null);
    }

    private void checkUpdateZoom() {
        Zoom newZoom;
        Integer zoomPercent;
        String zoomText = this.txtLevel.getText();
        if (zoomText != null && zoomText.length() > 0 && (zoomPercent = this.zoomValidator.parseLevel(zoomText)) != null && this.zoomValidator.isLevelInRange(zoomPercent) && !(newZoom = new Zoom(zoomPercent)).equals((Object)this.getCurrentZoom())) {
            new ZoomCmdDisp().doZoom(null, newZoom);
            return;
        }
        this.revertZoomText();
    }

    private Zoom getCurrentZoom() {
        return this.diagram_.getZoom();
    }

    private void revertZoomText() {
        this.txtLevel.setText(this.getCurrentZoom().getAsPercent().toString());
    }

    private class ZoomTextKeyListener
    implements KeyListener {
        private ZoomTextKeyListener() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 9: 
                case 10: {
                    ZoomToolbar.this.checkUpdateZoom();
                    break;
                }
                case 27: {
                    ZoomToolbar.this.revertZoomText();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }
    }

    private class ZoomTextFocusListener
    implements FocusListener {
        private ZoomTextFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
        }

        @Override
        public void focusLost(FocusEvent e) {
            ZoomToolbar.this.checkUpdateZoom();
        }
    }
}

