/*
 * Decompiled with CFR 0.152.
 */
package com.harrand.nb8;

import com.harrand.coreclasses.list.INodeTree;
import com.harrand.coreclasses.list.NodeTreeMgr;
import com.harrand.coreclasses.nb.CentralLookup;
import com.harrand.dbwrench.object.Database;
import com.harrand.dbwrench.object.LookupUtil;
import com.harrand.dbwrenchnb.action.db.IExplorerExpandedPathsProvider;
import com.harrand.dbwrenchnb.action.db.SaveUtil;
import com.harrand.dbwrenchnb.lifecycle.DevSetup;
import com.harrand.dbwrenchnb.nb.NbUtil;
import com.harrand.dbwrenchnb.nb.NodeExpansionMgr;
import com.harrand.dbwrenchnb.tree.node.DbNbNode;
import com.harrand.dbwrenchnb.tree.node.EmptyNode;
import com.harrand.dbwrenchnb.tree.panel.myBTV;
import com.harrand.nb8.Bundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.ActionMap;
import javax.swing.GroupLayout;
import javax.swing.JScrollPane;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.TopComponent;

@TopComponent.Description(preferredID="DbExplorerTopComponent", persistenceType=0)
public final class DbExplorerTopComponent
extends TopComponent
implements ExplorerManager.Provider,
LookupListener,
INodeTree,
DropTargetListener,
IExplorerExpandedPathsProvider {
    private final ExplorerManager mgr_ = new ExplorerManager();
    private NodeExpansionMgr expansionMgr_;
    private Lookup.Template template_;
    private Lookup.Result dbResult_;
    private boolean isNotifySrc_ = false;
    public static final String DISPLAY_NM = "Database Explorer";
    private static final String NO_DB_OPEN_HTML = "&lt;no database open&gt;";
    public static final String PREFERRED_ID = "DbExplorerTopComponent";
    private JScrollPane scrollpane;

    public DbExplorerTopComponent() {
        this.initComponents();
        this.setName(Bundle.CTL_DbExplorerTopComponent());
        this.setToolTipText(Bundle.HINT_DbExplorerTopComponent());
        this.checkDbLoaded();
        this.addCentralLookupListener();
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.mgr_, (ActionMap)this.getActionMap()));
        this.setDnd();
        this.expansionMgr_ = new NodeExpansionMgr((TreeView)this.scrollpane);
        this.addMgrListener();
        NodeTreeMgr.getInstance().setNodeTree((INodeTree)this);
        SaveUtil.getInstance().setExplorerExpandedPathsProvider((IExplorerExpandedPathsProvider)this);
    }

    public NodeExpansionMgr getNodeExpansionMgr() {
        return this.expansionMgr_;
    }

    public List<String> getExpandedPaths() {
        return this.expansionMgr_.getExpandedPaths(this.mgr_.getRootContext());
    }

    private void addMgrListener() {
        this.mgr_.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Node[] nodes = DbExplorerTopComponent.this.mgr_.getSelectedNodes();
                if (nodes.length > 0) {
                    Node node = nodes[0];
                    Object objLookup = node.getLookup().lookup(Object.class);
                    DbExplorerTopComponent.this.isNotifySrc_ = true;
                    CentralLookup.getDefault().addOrReplace(objLookup);
                    DbExplorerTopComponent.this.isNotifySrc_ = false;
                }
            }
        });
    }

    private void checkDbLoaded() {
        Database db = LookupUtil.findDb();
        if (db != null) {
            this.setDbNode(db);
        } else {
            this.setEmptyNode();
        }
    }

    private void addCentralLookupListener() {
        this.template_ = new Lookup.Template(Database.class);
        CentralLookup central = CentralLookup.getDefault();
        this.dbResult_ = central.lookup(this.template_);
        this.dbResult_.addLookupListener((LookupListener)this);
    }

    public ExplorerManager getExplorerManager() {
        return this.mgr_;
    }

    public void resultChanged(LookupEvent evt) {
        if (this.isNotifySrc_) {
            return;
        }
        Object o = evt.getSource();
        if (o != null) {
            Lookup.Result r = (Lookup.Result)o;
            Collection objs = r.allInstances();
            ArrayList list = new ArrayList(objs);
            if (list.isEmpty()) {
                this.setEmptyNode();
            } else {
                Object objA = list.get(0);
                if (objA instanceof Database) {
                    this.dbResultChanged(objA);
                }
            }
        }
    }

    private void dbResultChanged(Object dbObj) {
        Database db = (Database)dbObj;
        this.setDbNode(db);
    }

    private void setDbNode(Database db) {
        this.mgr_.setRootContext((Node)new DbNbNode(db));
        if (db != null) {
            this.expansionMgr_.setExpandedPaths(db.getExplorerPaths());
            this.expansionMgr_.expandNodes(this.mgr_.getRootContext());
        }
    }

    private void setDnd() {
        new DropTarget((Component)((Object)this), 3, this);
    }

    private void setEmptyNode() {
        try {
            this.mgr_.setSelectedNodes(new Node[0]);
        }
        catch (PropertyVetoException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.mgr_.setRootContext((Node)new EmptyNode(NO_DB_OPEN_HTML));
    }

    private void initComponents() {
        this.scrollpane = new myBTV();
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollpane, -1, 543, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.scrollpane, -1, 440, Short.MAX_VALUE).addContainerGap()));
    }

    public void componentOpened() {
        DevSetup.loadDevSetup();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
    }

    public String getSelectedPath() {
        String selectedPath = null;
        Node[] selNodes = this.mgr_.getSelectedNodes();
        if (selNodes.length > 0) {
            Node nodeA = selNodes[0];
            selectedPath = NbUtil.getNodePath((Node)nodeA);
        }
        return selectedPath;
    }

    public void setSelectionPath(String nodePath) {
        Node matchingNode = NbUtil.getNodeFromPath((ExplorerManager)this.mgr_, (String)nodePath);
        if (matchingNode != null) {
            NbUtil.selectNode((ExplorerManager)this.mgr_, (Node)matchingNode);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return null;
        }
    }
}

